/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static final Logger logger = LoggerFactory.getLogger(JSONUtils.class);
    private static final SimpleModule LOCAL_DATE_TIME_MODULE;
    private static final ObjectMapper objectMapper;

    private JSONUtils() {
        throw new UnsupportedOperationException("Construct JSONUtils");
    }

    public static ArrayNode createArrayNode() {
        return objectMapper.createArrayNode();
    }

    public static ObjectNode createObjectNode() {
        return objectMapper.createObjectNode();
    }

    public static JsonNode toJsonNode(Object obj) {
        return objectMapper.valueToTree(obj);
    }

    public static String toJsonString(Object object, SerializationFeature feature) {
        try {
            ObjectWriter writer = objectMapper.writer(feature);
            return writer.writeValueAsString(object);
        }
        catch (Exception e) {
            logger.error("object to json exception!", (Throwable)e);
            return null;
        }
    }

    public static <T> T parseObject(String json, Class<T> clazz) {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            logger.error("parse object exception!", (Throwable)e);
            return null;
        }
    }

    public static <T> T parseObject(byte[] src, Class<T> clazz) {
        if (src == null) {
            return null;
        }
        String json = new String(src, StandardCharsets.UTF_8);
        return JSONUtils.parseObject(json, clazz);
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        if (StringUtils.isEmpty(json)) {
            return Collections.emptyList();
        }
        try {
            CollectionType listType = objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, clazz);
            return (List)objectMapper.readValue(json, (JavaType)listType);
        }
        catch (Exception e) {
            logger.error("parse list exception!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static Map<String, String> toMap(String json) {
        return JSONUtils.parseObject(json, new TypeReference<Map<String, String>>(){});
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> classK, Class<V> classV) {
        return (Map)JSONUtils.parseObject(json, new TypeReference<Map<K, V>>(){});
    }

    public static <T> T parseObject(String json, TypeReference<T> type) {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, type);
        }
        catch (Exception e) {
            logger.error("json to map exception!", (Throwable)e);
            return null;
        }
    }

    public static String toJsonString(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Object json deserialization exception.", e);
        }
    }

    public static <T> byte[] toJsonByteArray(T obj) {
        if (obj == null) {
            return null;
        }
        String json = "";
        try {
            json = JSONUtils.toJsonString(obj);
        }
        catch (Exception e) {
            logger.error("json serialize exception.", (Throwable)e);
        }
        return json.getBytes(StandardCharsets.UTF_8);
    }

    public static ObjectNode parseObject(String text) {
        try {
            if (text.isEmpty()) {
                return JSONUtils.parseObject(text, ObjectNode.class);
            }
            return (ObjectNode)objectMapper.readTree(text);
        }
        catch (Exception e) {
            throw new RuntimeException("String json deserialization exception.", e);
        }
    }

    public static ArrayNode parseArray(String text) {
        try {
            return (ArrayNode)objectMapper.readTree(text);
        }
        catch (Exception e) {
            throw new RuntimeException("Json deserialization exception.", e);
        }
    }

    static {
        logger.info("init timezone: {}", (Object)TimeZone.getDefault());
        LOCAL_DATE_TIME_MODULE = new SimpleModule().addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer()).addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
        objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, true).registerModule((Module)LOCAL_DATE_TIME_MODULE).setTimeZone(TimeZone.getDefault()).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }

    public static class LocalDateTimeDeserializer
    extends JsonDeserializer<LocalDateTime> {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

        public LocalDateTime deserialize(JsonParser p, DeserializationContext context) throws IOException {
            return LocalDateTime.parse(p.getValueAsString(), this.formatter);
        }
    }

    public static class LocalDateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

        public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.format(this.formatter));
        }
    }

    public static class JsonDataDeserializer
    extends JsonDeserializer<String> {
        public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            if (node instanceof TextNode) {
                return node.asText();
            }
            return node.toString();
        }
    }
}

