/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.params.base;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum FormType {
    INPUT("input"),
    INPUTNUMBER("inputNumber"),
    RADIO("radio"),
    SELECT("select"),
    SWITCH("switch"),
    CHECKBOX("checkbox"),
    TIMEPICKER("timePicker"),
    DATEPICKER("datePicker"),
    SLIDER("slider"),
    RATE("rate"),
    COLORPICKER("colorPicker"),
    CASCADER("cascader"),
    UPLOAD("upload"),
    ELTRANSFER("el-transfer"),
    TREE("tree"),
    TEXTAREA("textarea"),
    GROUP("group");

    private String formType;
    private static final Map<String, FormType> FORM_TYPE_MAP;

    private FormType(String formType) {
        this.formType = formType;
    }

    @JsonValue
    public String getFormType() {
        return this.formType;
    }

    public static FormType of(String type) {
        if (FORM_TYPE_MAP.containsKey(type)) {
            return FORM_TYPE_MAP.get(type);
        }
        return null;
    }

    static {
        FORM_TYPE_MAP = Arrays.stream(FormType.values()).collect(Collectors.toMap(FormType::getFormType, Functions.identity()));
    }
}

