/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.scheduler.quartz;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.scheduler.quartz.utils.QuartzTaskUtils;
import org.apache.dolphinscheduler.service.command.CommandService;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ProcessScheduleTask
extends QuartzJobBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessScheduleTask.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private CommandService commandService;

    @Counted(value="ds.master.quartz.job.executed")
    @Timed(value="ds.master.quartz.job.execution.time", percentiles={0.5, 0.75, 0.95, 0.99}, histogram=true)
    protected void executeInternal(JobExecutionContext context) {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        int projectId = dataMap.getInt("projectId");
        int scheduleId = dataMap.getInt("scheduleId");
        Date scheduledFireTime = context.getScheduledFireTime();
        Date fireTime = context.getFireTime();
        log.info("scheduled fire time :{}, fire time :{}, scheduleId :{}", new Object[]{scheduledFireTime, fireTime, scheduleId});
        Schedule schedule = this.processService.querySchedule(scheduleId);
        if (schedule == null || ReleaseState.OFFLINE == schedule.getReleaseState()) {
            log.warn("process schedule does not exist in db or process schedule offline\uff0cdelete schedule job in quartz, projectId:{}, scheduleId:{}", (Object)projectId, (Object)scheduleId);
            this.deleteJob(context, projectId, scheduleId);
            return;
        }
        ProcessDefinition processDefinition = this.processService.findProcessDefinitionByCode(Long.valueOf(schedule.getProcessDefinitionCode()));
        ReleaseState releaseState = processDefinition.getReleaseState();
        if (releaseState == ReleaseState.OFFLINE) {
            log.warn("process definition does not exist in db or offline\uff0cneed not to create command, projectId:{}, processDefinitionId:{}", (Object)projectId, (Object)processDefinition.getId());
            return;
        }
        Command command = new Command();
        command.setCommandType(CommandType.SCHEDULER);
        command.setExecutorId(schedule.getUserId());
        command.setFailureStrategy(schedule.getFailureStrategy());
        command.setProcessDefinitionCode(schedule.getProcessDefinitionCode());
        command.setScheduleTime(scheduledFireTime);
        command.setStartTime(fireTime);
        command.setWarningGroupId(Integer.valueOf(schedule.getWarningGroupId()));
        String workerGroup = StringUtils.isEmpty((CharSequence)schedule.getWorkerGroup()) ? "default" : schedule.getWorkerGroup();
        command.setWorkerGroup(workerGroup);
        command.setTenantCode(schedule.getTenantCode());
        command.setEnvironmentCode(schedule.getEnvironmentCode());
        command.setWarningType(schedule.getWarningType());
        command.setProcessInstancePriority(schedule.getProcessInstancePriority());
        command.setProcessDefinitionVersion(processDefinition.getVersion());
        this.commandService.createCommand(command);
    }

    private void deleteJob(JobExecutionContext context, int projectId, int scheduleId) {
        Scheduler scheduler = context.getScheduler();
        JobKey jobKey = QuartzTaskUtils.getJobKey(scheduleId, projectId);
        try {
            if (scheduler.checkExists(jobKey)) {
                log.info("Try to delete job: {}, projectId: {}, schedulerId", (Object)projectId, (Object)scheduleId);
                scheduler.deleteJob(jobKey);
            }
        }
        catch (Exception e) {
            log.error("Failed to delete job: {}", (Object)jobKey);
        }
    }
}

