/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.service.SessionService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.dao.entity.Session;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.repository.SessionDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SessionServiceImpl
extends BaseServiceImpl
implements SessionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionServiceImpl.class);
    @Autowired
    private SessionDao sessionDao;

    @Override
    public Session getSession(String sessionId) {
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            return null;
        }
        return (Session)this.sessionDao.queryById((Serializable)((Object)sessionId));
    }

    @Override
    @Transactional
    public Session createSessionIfAbsent(User user) {
        List sessionList = this.sessionDao.queryByUserId(user.getId());
        if (CollectionUtils.isNotEmpty((Collection)sessionList)) {
            Session session;
            if (sessionList.size() > 1) {
                for (int i = 1; i < sessionList.size(); ++i) {
                    this.sessionDao.deleteById((Serializable)((Object)((Session)sessionList.get(i)).getId()));
                }
            }
            if (this.isSessionExpire(session = (Session)sessionList.get(0))) {
                session.setLastLoginTime(new Date());
                this.sessionDao.updateById((Object)session);
                return session;
            }
            this.sessionDao.deleteById((Serializable)((Object)session.getId()));
        }
        Session newSession = Session.builder().id(UUID.randomUUID().toString()).userId(user.getId().intValue()).lastLoginTime(new Date()).build();
        this.sessionDao.insert((Object)newSession);
        return newSession;
    }

    @Override
    public void expireSession(Integer userId) {
        this.sessionDao.deleteByUserId(userId);
    }

    @Override
    public boolean isSessionExpire(Session session) {
        return System.currentTimeMillis() - session.getLastLoginTime().getTime() <= 0x6DDD00L;
    }
}

