/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.resources.DeleteDataTransferResponse;
import org.apache.dolphinscheduler.api.dto.resources.filter.ResourceFilter;
import org.apache.dolphinscheduler.api.dto.resources.visitor.ResourceTreeVisitor;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.metrics.ApiServerMetrics;
import org.apache.dolphinscheduler.api.service.ResourcesService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.FileUtils;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.RegexUtils;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UdfFuncMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperate;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ResourcesServiceImpl
extends BaseServiceImpl
implements ResourcesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourcesServiceImpl.class);
    @Autowired
    private UdfFuncMapper udfFunctionMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired(required=false)
    private StorageOperate storageOperate;

    @Override
    @Transactional
    public Result<Object> createDirectory(User loginUser, String name, ResourceType type, int pid, String currentDir) {
        Result<Object> result = new Result<Object>();
        if (org.apache.dolphinscheduler.common.utils.FileUtils.directoryTraversal((String)name)) {
            log.warn("Parameter name is invalid, name:{}.", (Object)RegexUtils.escapeNRT(name));
            this.putMsg((Result)result, Status.VERIFY_PARAMETER_NAME_FAILED, new Object[0]);
            return result;
        }
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg((Result)result, Status.USER_NOT_EXIST, new Object[]{loginUser.getId()});
            return result;
        }
        String tenantCode = this.getTenantCode(user);
        if (!this.isUserTenantValid(this.isAdmin(loginUser), tenantCode, "")) {
            log.error("current user does not have permission");
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        String userResRootPath = ResourceType.UDF.equals((Object)type) ? this.storageOperate.getUdfDir(tenantCode) : this.storageOperate.getResDir(tenantCode);
        String fullName = !currentDir.contains(userResRootPath) ? userResRootPath + name : currentDir + name;
        try {
            if (this.checkResourceExists(fullName)) {
                log.error("resource directory {} has exist, can't recreate", (Object)fullName);
                this.putMsg((Result)result, Status.RESOURCE_EXIST, new Object[0]);
                return result;
            }
        }
        catch (Exception e) {
            log.warn("Resource exists, can not create again, fullName:{}.", (Object)fullName, (Object)e);
            throw new ServiceException("resource already exists, can't recreate");
        }
        this.createDirectory(loginUser, fullName, type, result);
        return result;
    }

    private String getFullName(String currentDir, String name) {
        return currentDir.equals("/") ? String.format("%s%s", currentDir, name) : String.format("%s/%s", currentDir, name);
    }

    @Override
    @Transactional
    public Result<Object> createResource(User loginUser, String name, ResourceType type, MultipartFile file, String currentDir) {
        Result<Object> result = new Result<Object>();
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg((Result)result, Status.USER_NOT_EXIST, new Object[]{loginUser.getId()});
            return result;
        }
        String tenantCode = this.getTenantCode(user);
        if (!this.isUserTenantValid(this.isAdmin(loginUser), tenantCode, "")) {
            log.error("current user does not have permission");
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        result = this.verifyFile(name, type, file);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        String userResRootPath = ResourceType.UDF.equals((Object)type) ? this.storageOperate.getUdfDir(tenantCode) : this.storageOperate.getResDir(tenantCode);
        String currDirNFileName = !currentDir.contains(userResRootPath) ? userResRootPath + name : currentDir + name;
        try {
            if (this.checkResourceExists(currDirNFileName)) {
                log.error("resource {} has exist, can't recreate", (Object)RegexUtils.escapeNRT(name));
                this.putMsg((Result)result, Status.RESOURCE_EXIST, new Object[0]);
                return result;
            }
        }
        catch (Exception e) {
            throw new ServiceException("resource already exists, can't recreate");
        }
        if (currDirNFileName.length() > 128) {
            log.error("Resource file's name is longer than max full name length, fullName:{}, fullNameSize:{}, maxFullNameSize:{}", new Object[]{RegexUtils.escapeNRT(name), currDirNFileName.length(), 128});
            this.putMsg((Result)result, Status.RESOURCE_FULL_NAME_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        if (!this.upload(loginUser, currDirNFileName, file, type)) {
            log.error("upload resource: {} file: {} failed.", (Object)RegexUtils.escapeNRT(name), (Object)RegexUtils.escapeNRT(file.getOriginalFilename()));
            this.putMsg((Result)result, Status.STORE_OPERATE_CREATE_ERROR, new Object[0]);
            throw new ServiceException(String.format("upload resource: %s file: %s failed.", name, file.getOriginalFilename()));
        }
        ApiServerMetrics.recordApiResourceUploadSize(file.getSize());
        log.info("Upload resource file complete, resourceName:{}, fileName:{}.", (Object)RegexUtils.escapeNRT(name), (Object)RegexUtils.escapeNRT(file.getOriginalFilename()));
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkResourceExists(String fullName) {
        Boolean existResource = false;
        try {
            existResource = this.storageOperate.exists(fullName);
        }
        catch (IOException e) {
            log.error("error occurred when checking resource: " + fullName, (Throwable)e);
        }
        return Boolean.TRUE.equals(existResource);
    }

    @Override
    @Transactional
    public Result<Object> updateResource(User loginUser, String resourceFullName, String resTenantCode, String name, ResourceType type, MultipartFile file) {
        StorageEntity resource;
        Result<Object> result = new Result<Object>();
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg((Result)result, Status.USER_NOT_EXIST, new Object[]{loginUser.getId()});
            return result;
        }
        String tenantCode = this.getTenantCode(user);
        if (!this.isUserTenantValid(this.isAdmin(loginUser), tenantCode, resTenantCode)) {
            log.error("current user does not have permission");
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        String defaultPath = this.storageOperate.getResDir(tenantCode);
        try {
            resource = this.storageOperate.getFileStatus(resourceFullName, defaultPath, resTenantCode, type);
        }
        catch (Exception e) {
            log.error("Get file status fail, resource path: {}", (Object)resourceFullName, (Object)e);
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            throw new ServiceException(String.format("Get file status fail, resource path: %s", resourceFullName));
        }
        if (resource.isDirectory() && this.storageOperate.returnStorageType().equals((Object)ResUploadType.S3) && !resource.getFileName().equals(name)) {
            log.warn("Directory in S3 storage can not be renamed.");
            this.putMsg((Result)result, Status.S3_CANNOT_RENAME, new Object[0]);
            return result;
        }
        String originFullName = resource.getFullName();
        String originResourceName = resource.getAlias();
        originFullName = originFullName.endsWith("/") ? StringUtils.chop((String)originFullName) : originFullName;
        name = name.endsWith("/") ? StringUtils.chop((String)name) : name;
        String fullName = String.format("%s%s", originFullName.substring(0, originFullName.lastIndexOf("/") + 1), name);
        if (!originResourceName.equals(name)) {
            try {
                if (this.checkResourceExists(fullName)) {
                    log.error("resource {} already exists, can't recreate", (Object)fullName);
                    this.putMsg((Result)result, Status.RESOURCE_EXIST, new Object[0]);
                    return result;
                }
            }
            catch (Exception e) {
                throw new ServiceException(String.format("error occurs while querying resource: %s", fullName));
            }
        }
        if (!(result = this.verifyFile(name, type, file)).getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        Date now = new Date();
        resource.setAlias(name);
        resource.setFileName(name);
        resource.setFullName(fullName);
        resource.setUpdateTime(now);
        if (file != null) {
            resource.setSize(file.getSize());
        }
        if (originResourceName.equals(name) && file == null) {
            return result;
        }
        if (file != null) {
            if (!this.upload(loginUser, fullName, file, type)) {
                log.error("Storage operation error, resourceName:{}, originFileName:{}.", (Object)name, (Object)RegexUtils.escapeNRT(file.getOriginalFilename()));
                this.putMsg((Result)result, Status.HDFS_OPERATION_ERROR, new Object[0]);
                throw new ServiceException(String.format("upload resource: %s file: %s failed.", name, file.getOriginalFilename()));
            }
            if (!fullName.equals(originFullName)) {
                try {
                    this.storageOperate.delete(originFullName, false);
                }
                catch (IOException e) {
                    log.error("Resource delete error, resourceFullName:{}.", (Object)originFullName, (Object)e);
                    throw new ServiceException(String.format("delete resource: %s failed.", originFullName));
                }
            }
            ApiServerMetrics.recordApiResourceUploadSize(file.getSize());
            return result;
        }
        String destHdfsFileName = fullName;
        try {
            log.info("start  copy {} -> {}", (Object)originFullName, (Object)destHdfsFileName);
            this.storageOperate.copy(originFullName, destHdfsFileName, true, true);
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        catch (Exception e) {
            log.error(MessageFormat.format(" copy {0} -> {1} fail", originFullName, destHdfsFileName), (Throwable)e);
            this.putMsg((Result)result, Status.HDFS_COPY_FAIL, new Object[0]);
            throw new ServiceException(MessageFormat.format(Status.HDFS_COPY_FAIL.getMsg(), originFullName, destHdfsFileName));
        }
        return result;
    }

    private Result<Object> verifyFile(String name, ResourceType type, MultipartFile file) {
        Result<Object> result = new Result<Object>();
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        if (org.apache.dolphinscheduler.common.utils.FileUtils.directoryTraversal((String)name)) {
            log.warn("Parameter file alias name verify failed, fileAliasName:{}.", (Object)RegexUtils.escapeNRT(name));
            this.putMsg((Result)result, Status.VERIFY_PARAMETER_NAME_FAILED, new Object[0]);
            return result;
        }
        if (file != null && org.apache.dolphinscheduler.common.utils.FileUtils.directoryTraversal((String)Objects.requireNonNull(file.getOriginalFilename()))) {
            log.warn("File original name verify failed, fileOriginalName:{}.", (Object)RegexUtils.escapeNRT(file.getOriginalFilename()));
            this.putMsg((Result)result, Status.VERIFY_PARAMETER_NAME_FAILED, new Object[0]);
            return result;
        }
        if (file != null) {
            String nameSuffix;
            if (file.isEmpty()) {
                log.warn("Parameter file is empty, fileOriginalName:{}.", (Object)RegexUtils.escapeNRT(file.getOriginalFilename()));
                this.putMsg((Result)result, Status.RESOURCE_FILE_IS_EMPTY, new Object[0]);
                return result;
            }
            String fileSuffix = com.google.common.io.Files.getFileExtension((String)file.getOriginalFilename());
            if (!fileSuffix.equalsIgnoreCase(nameSuffix = com.google.common.io.Files.getFileExtension((String)name))) {
                log.warn("Rename file suffix and original suffix must be consistent, fileOriginalName:{}.", (Object)RegexUtils.escapeNRT(file.getOriginalFilename()));
                this.putMsg((Result)result, Status.RESOURCE_SUFFIX_FORBID_CHANGE, new Object[0]);
                return result;
            }
            if ("UDF".equals(type.name()) && !"jar".equalsIgnoreCase(fileSuffix)) {
                log.warn(Status.UDF_RESOURCE_SUFFIX_NOT_JAR.getMsg());
                this.putMsg((Result)result, Status.UDF_RESOURCE_SUFFIX_NOT_JAR, new Object[0]);
                return result;
            }
            if (file.getSize() > 0x40000000L) {
                log.warn("Resource file size is larger than max file size, fileOriginalName:{}, fileSize:{}, maxFileSize:{}.", new Object[]{RegexUtils.escapeNRT(file.getOriginalFilename()), file.getSize(), 0x40000000});
                this.putMsg((Result)result, Status.RESOURCE_SIZE_EXCEED_LIMIT, new Object[0]);
                return result;
            }
        }
        return result;
    }

    @Override
    public Result<PageInfo<StorageEntity>> queryResourceListPaging(User loginUser, String fullName, String resTenantCode, ResourceType type, String searchVal, Integer pageNo, Integer pageSize) {
        String baseDir;
        Result<PageInfo<StorageEntity>> result = new Result<PageInfo<StorageEntity>>();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        if (this.storageOperate == null) {
            log.warn("The resource storage is not opened.");
            return Result.success(pageInfo);
        }
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg(result, Status.USER_NOT_EXIST, new Object[]{loginUser.getId()});
            return result;
        }
        String tenantCode = this.getTenantCode(user);
        String string = baseDir = this.isAdmin(loginUser) ? this.storageOperate.getDir(ResourceType.ALL, tenantCode) : this.storageOperate.getDir(type, tenantCode);
        if (!this.isUserTenantValid(this.isAdmin(loginUser), tenantCode, resTenantCode) || StringUtils.isNotBlank((CharSequence)fullName) && !StringUtils.startsWith((CharSequence)fullName, (CharSequence)baseDir)) {
            log.error("current user does not have permission");
            this.putMsg(result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        List<Object> resourcesList = new ArrayList();
        try {
            resourcesList = this.queryStorageEntityList(loginUser, fullName, type, tenantCode, false);
        }
        catch (ServiceException e) {
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        String trimmedSearchVal = searchVal != null ? searchVal.trim() : "";
        List filteredResourceList = resourcesList.stream().filter(x -> x.getFileName().contains(trimmedSearchVal)).collect(Collectors.toList());
        List slicedResourcesList = filteredResourceList.stream().skip((long)(pageNo - 1) * (long)pageSize.intValue()).limit(pageSize.intValue()).collect(Collectors.toList());
        pageInfo.setTotal(filteredResourceList.size());
        pageInfo.setTotalList(slicedResourcesList);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private List<StorageEntity> queryStorageEntityList(User loginUser, String fullName, ResourceType type, String tenantCode, boolean recursive) {
        String defaultPath = "";
        List<Object> resourcesList = new ArrayList<StorageEntity>();
        String resourceStorageType = PropertyUtils.getString((String)"resource.storage.type", (String)ResUploadType.LOCAL.name());
        if (this.isAdmin(loginUser) && StringUtils.isBlank((CharSequence)fullName)) {
            List userList = this.userMapper.selectList(null);
            HashSet<String> visitedTenantEntityCode = new HashSet<String>();
            for (User userEntity : userList) {
                String tenantEntityCode = this.getTenantCode(userEntity);
                if (visitedTenantEntityCode.contains(tenantEntityCode)) continue;
                defaultPath = this.storageOperate.getResDir(tenantEntityCode);
                if (type.equals((Object)ResourceType.UDF)) {
                    defaultPath = this.storageOperate.getUdfDir(tenantEntityCode);
                }
                try {
                    resourcesList.addAll(recursive ? this.storageOperate.listFilesStatusRecursively(defaultPath, defaultPath, tenantEntityCode, type) : this.storageOperate.listFilesStatus(defaultPath, defaultPath, tenantEntityCode, type));
                    visitedTenantEntityCode.add(tenantEntityCode);
                }
                catch (Exception e) {
                    log.error(e.getMessage() + " Resource path: {}", (Object)defaultPath, (Object)e);
                    throw new ServiceException(String.format(e.getMessage() + " make sure resource path: %s exists in %s", defaultPath, resourceStorageType));
                }
            }
        } else {
            defaultPath = this.storageOperate.getResDir(tenantCode);
            if (type.equals((Object)ResourceType.UDF)) {
                defaultPath = this.storageOperate.getUdfDir(tenantCode);
            }
            try {
                if (StringUtils.isBlank((CharSequence)fullName)) {
                    fullName = defaultPath;
                }
                resourcesList = recursive ? this.storageOperate.listFilesStatusRecursively(fullName, defaultPath, tenantCode, type) : this.storageOperate.listFilesStatus(fullName, defaultPath, tenantCode, type);
            }
            catch (Exception e) {
                log.error(e.getMessage() + " Resource path: {}", (Object)fullName, (Object)e);
                throw new ServiceException(String.format(e.getMessage() + " make sure resource path: %s exists in %s", defaultPath, resourceStorageType));
            }
        }
        return resourcesList;
    }

    private void createDirectory(User loginUser, String fullName, ResourceType type, Result<Object> result) {
        String tenantCode = this.tenantMapper.queryById(loginUser.getTenantId()).getTenantCode();
        String resourceRootPath = this.storageOperate.getDir(type, tenantCode);
        try {
            if (!this.storageOperate.exists(resourceRootPath)) {
                this.storageOperate.createTenantDirIfNotExists(tenantCode);
            }
            if (!this.storageOperate.mkdir(tenantCode, fullName)) {
                throw new ServiceException(String.format("Create resource directory: %s failed.", fullName));
            }
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        catch (Exception e) {
            throw new ServiceException(String.format("create resource directory: %s failed.", fullName));
        }
    }

    private boolean upload(User loginUser, String fullName, MultipartFile file, ResourceType type) {
        String nameSuffix;
        String fileSuffix = com.google.common.io.Files.getFileExtension((String)file.getOriginalFilename());
        if (!fileSuffix.equalsIgnoreCase(nameSuffix = com.google.common.io.Files.getFileExtension((String)fullName))) {
            return false;
        }
        String tenantCode = this.getTenantCode(loginUser);
        String localFilename = org.apache.dolphinscheduler.common.utils.FileUtils.getUploadFilename((String)tenantCode, (String)UUID.randomUUID().toString());
        String resourcePath = this.storageOperate.getDir(type, tenantCode);
        try {
            if (!this.storageOperate.exists(resourcePath)) {
                this.storageOperate.createTenantDirIfNotExists(tenantCode);
            }
            FileUtils.copyInputStreamToFile(file, localFilename);
            this.storageOperate.upload(tenantCode, localFilename, fullName, true, true);
        }
        catch (Exception e) {
            org.apache.dolphinscheduler.common.utils.FileUtils.deleteFile((String)localFilename);
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> queryResourceList(User loginUser, ResourceType type, String fullName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.storageOperate == null) {
            result.put("data", Collections.emptyList());
            result.put("status", (Object)Status.SUCCESS);
            return result;
        }
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg(result, Status.USER_NOT_EXIST, loginUser.getId());
            return null;
        }
        String tenantCode = this.getTenantCode(user);
        String defaultPath = "";
        List resourcesList = new ArrayList();
        if (StringUtils.isBlank((CharSequence)fullName)) {
            if (this.isAdmin(loginUser)) {
                List userList = this.userMapper.selectList(null);
                HashSet<String> visitedTenantEntityCode = new HashSet<String>();
                for (User userEntity : userList) {
                    String tenantEntityCode = this.getTenantCode(userEntity);
                    if (visitedTenantEntityCode.contains(tenantEntityCode)) continue;
                    defaultPath = this.storageOperate.getResDir(tenantEntityCode);
                    if (type.equals((Object)ResourceType.UDF)) {
                        defaultPath = this.storageOperate.getUdfDir(tenantEntityCode);
                    }
                    resourcesList.addAll(this.storageOperate.listFilesStatusRecursively(defaultPath, defaultPath, tenantEntityCode, type));
                    visitedTenantEntityCode.add(tenantEntityCode);
                }
            } else {
                defaultPath = this.storageOperate.getResDir(tenantCode);
                if (type.equals((Object)ResourceType.UDF)) {
                    defaultPath = this.storageOperate.getUdfDir(tenantCode);
                }
                resourcesList = this.storageOperate.listFilesStatusRecursively(defaultPath, defaultPath, tenantCode, type);
            }
        } else {
            defaultPath = this.storageOperate.getResDir(tenantCode);
            if (type.equals((Object)ResourceType.UDF)) {
                defaultPath = this.storageOperate.getUdfDir(tenantCode);
            }
            resourcesList = this.storageOperate.listFilesStatusRecursively(fullName, defaultPath, tenantCode, type);
        }
        ResourceTreeVisitor resourceTreeVisitor = new ResourceTreeVisitor(resourcesList);
        result.put("data", resourceTreeVisitor.visit(defaultPath).getChildren());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> queryResourceByProgramType(User loginUser, ResourceType type, ProgramType programType) {
        Result<Object> result = new Result<Object>();
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg((Result)result, Status.USER_NOT_EXIST, new Object[]{loginUser.getId()});
            return result;
        }
        Tenant tenant = this.tenantMapper.queryById(user.getTenantId());
        if (tenant == null) {
            log.error("tenant not exists");
            this.putMsg((Result)result, Status.CURRENT_LOGIN_USER_TENANT_NOT_EXIST, new Object[0]);
            return result;
        }
        String tenantCode = tenant.getTenantCode();
        List<StorageEntity> allResourceList = this.queryStorageEntityList(loginUser, "", type, tenantCode, true);
        String suffix = ".jar";
        if (programType != null) {
            switch (programType) {
                case JAVA: 
                case SCALA: {
                    break;
                }
                case PYTHON: {
                    suffix = ".py";
                    break;
                }
            }
        }
        List<StorageEntity> resources = new ResourceFilter(suffix, new ArrayList<StorageEntity>(allResourceList)).filter();
        ResourceTreeVisitor visitor = new ResourceTreeVisitor(resources);
        result.setData(visitor.visit("").getChildren());
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Object> delete(User loginUser, String fullName, String resTenantCode) throws IOException {
        List udfFuncs;
        StorageEntity resource;
        Result<Object> result = new Result<Object>();
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg((Result)result, Status.USER_NOT_EXIST, new Object[]{loginUser.getId()});
            return result;
        }
        String tenantCode = this.getTenantCode(user);
        if (!this.isUserTenantValid(this.isAdmin(loginUser), tenantCode, resTenantCode)) {
            log.error("current user does not have permission");
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        String defaultPath = this.storageOperate.getResDir(tenantCode);
        try {
            resource = this.storageOperate.getFileStatus(fullName, defaultPath, resTenantCode, null);
        }
        catch (Exception e) {
            log.error(e.getMessage() + " Resource path: {}", (Object)fullName, (Object)e);
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            throw new ServiceException(String.format(e.getMessage() + " Resource path: %s", fullName));
        }
        if (resource == null) {
            log.error("Resource does not exist, resource full name:{}.", (Object)fullName);
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        List allChildren = this.storageOperate.listFilesStatusRecursively(fullName, defaultPath, resTenantCode, resource.getType()).stream().map(storageEntity -> storageEntity.getFullName()).collect(Collectors.toList());
        String[] allChildrenFullNameArray = (String[])allChildren.stream().toArray(String[]::new);
        if (resource.getType() == ResourceType.UDF && CollectionUtils.isNotEmpty((Collection)(udfFuncs = this.udfFunctionMapper.listUdfByResourceFullName(allChildrenFullNameArray)))) {
            log.warn("Resource can not be deleted because it is bound by UDF functions, udfFuncIds:{}", (Object)udfFuncs);
            this.putMsg((Result)result, Status.UDF_RESOURCE_IS_BOUND, new Object[]{((UdfFunc)udfFuncs.get(0)).getFuncName()});
            return result;
        }
        this.storageOperate.delete(fullName, allChildren, true);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private String RemoveResourceFromResourceList(String stringToDelete, String taskParameter, boolean isDir) {
        Map taskParameters = (Map)JSONUtils.parseObject((String)taskParameter, (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (taskParameters.containsKey("resourceList")) {
            List updatedResourceInfoList;
            String resourceListStr = JSONUtils.toJsonString(taskParameters.get("resourceList"));
            List resourceInfoList = JSONUtils.toList((String)resourceListStr, ResourceInfo.class);
            if (isDir) {
                String stringToDeleteWSeparator = stringToDelete + "/";
                updatedResourceInfoList = resourceInfoList.stream().filter(Objects::nonNull).filter(resourceInfo -> !resourceInfo.getResourceName().startsWith(stringToDeleteWSeparator)).collect(Collectors.toList());
            } else {
                updatedResourceInfoList = resourceInfoList.stream().filter(Objects::nonNull).filter(resourceInfo -> !resourceInfo.getResourceName().equals(stringToDelete)).collect(Collectors.toList());
            }
            taskParameters.put("resourceList", updatedResourceInfoList);
            return JSONUtils.toJsonString((Object)taskParameters);
        }
        return taskParameter;
    }

    @Override
    public Result<Object> verifyResourceName(String fullName, ResourceType type, User loginUser) {
        Result<Object> result = new Result<Object>();
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        if (this.checkResourceExists(fullName)) {
            log.error("Resource with same name exists so can not create again, resourceType:{}, resourceName:{}.", (Object)type, (Object)RegexUtils.escapeNRT(fullName));
            this.putMsg((Result)result, Status.RESOURCE_EXIST, new Object[0]);
        }
        return result;
    }

    @Override
    public Result<Object> queryResourceByFileName(User loginUser, String fileName, ResourceType type, String resTenantCode) {
        StorageEntity file;
        Result<Object> result = new Result<Object>();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            this.putMsg((Result)result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, new Object[0]);
            return result;
        }
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg((Result)result, Status.USER_NOT_EXIST, new Object[]{loginUser.getId()});
            return result;
        }
        String tenantCode = this.getTenantCode(user);
        if (!this.isUserTenantValid(this.isAdmin(loginUser), tenantCode, resTenantCode)) {
            log.error("current user does not have permission");
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        String defaultPath = this.storageOperate.getResDir(resTenantCode);
        if (type.equals((Object)ResourceType.UDF)) {
            defaultPath = this.storageOperate.getUdfDir(resTenantCode);
        }
        try {
            file = this.storageOperate.getFileStatus(defaultPath + fileName, defaultPath, resTenantCode, type);
        }
        catch (Exception e) {
            log.error(e.getMessage() + " Resource path: {}", (Object)(defaultPath + fileName), (Object)e);
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        result.setData(file);
        return result;
    }

    @Override
    public Result<Object> queryResourceByFullName(User loginUser, String fullName, String resTenantCode, ResourceType type) throws IOException {
        StorageEntity file;
        Result<Object> result = new Result<Object>();
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg((Result)result, Status.USER_NOT_EXIST, new Object[]{loginUser.getId()});
            return result;
        }
        String tenantCode = this.getTenantCode(user);
        if (!this.isUserTenantValid(this.isAdmin(loginUser), tenantCode, resTenantCode)) {
            log.error("current user does not have permission");
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        String defaultPath = this.storageOperate.getResDir(resTenantCode);
        if (type.equals((Object)ResourceType.UDF)) {
            defaultPath = this.storageOperate.getUdfDir(resTenantCode);
        }
        try {
            file = this.storageOperate.getFileStatus(fullName, defaultPath, resTenantCode, type);
        }
        catch (Exception e) {
            log.error(e.getMessage() + " Resource path: {}", (Object)fullName, (Object)e);
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            throw new ServiceException(String.format(e.getMessage() + " Resource path: %s", fullName));
        }
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        result.setData(file);
        return result;
    }

    @Override
    public Result<Object> readResource(User loginUser, String fullName, String resTenantCode, int skipLineNum, int limit) {
        List<String> strList;
        Result<Object> result = new Result<Object>();
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg((Result)result, Status.USER_NOT_EXIST, new Object[]{loginUser.getId()});
            return result;
        }
        String tenantCode = this.getTenantCode(user);
        if (!this.isUserTenantValid(this.isAdmin(loginUser), tenantCode, resTenantCode)) {
            log.error("current user does not have permission");
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        String nameSuffix = com.google.common.io.Files.getFileExtension((String)fullName);
        String resourceViewSuffixes = org.apache.dolphinscheduler.common.utils.FileUtils.getResourceViewSuffixes();
        if (StringUtils.isNotEmpty((CharSequence)resourceViewSuffixes) && !(strList = Arrays.asList(resourceViewSuffixes.split(","))).contains(nameSuffix)) {
            log.error("Resource suffix does not support view,resourceFullName:{}, suffix:{}.", (Object)fullName, (Object)nameSuffix);
            this.putMsg((Result)result, Status.RESOURCE_SUFFIX_NOT_SUPPORT_VIEW, new Object[0]);
            return result;
        }
        List content = new ArrayList();
        try {
            if (!this.storageOperate.exists(fullName)) {
                log.error("read file {} not exist in storage", (Object)fullName);
                this.putMsg((Result)result, Status.RESOURCE_FILE_NOT_EXIST, new Object[]{fullName});
                return result;
            }
            content = this.storageOperate.vimFile(tenantCode, fullName, skipLineNum, limit);
            long size = content.stream().mapToLong(String::length).sum();
            ApiServerMetrics.recordApiResourceDownloadSize(size);
        }
        catch (Exception e) {
            log.error("Resource {} read failed", (Object)fullName, (Object)e);
            this.putMsg((Result)result, Status.HDFS_OPERATION_ERROR, new Object[0]);
            return result;
        }
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("alias", fullName);
        map.put("content", String.join((CharSequence)"\n", content));
        result.setData(map);
        return result;
    }

    @Override
    @Transactional
    public Result<Object> onlineCreateResource(User loginUser, ResourceType type, String fileName, String fileSuffix, String content, String currentDir) {
        List<String> strList;
        Result<Object> result = new Result<Object>();
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg((Result)result, Status.USER_NOT_EXIST, new Object[]{loginUser.getId()});
            return result;
        }
        String tenantCode = this.getTenantCode(user);
        if (!this.isUserTenantValid(this.isAdmin(loginUser), tenantCode, "")) {
            log.error("current user does not have permission");
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        if (org.apache.dolphinscheduler.common.utils.FileUtils.directoryTraversal((String)fileName)) {
            log.warn("File name verify failed, fileName:{}.", (Object)RegexUtils.escapeNRT(fileName));
            this.putMsg((Result)result, Status.VERIFY_PARAMETER_NAME_FAILED, new Object[0]);
            return result;
        }
        String nameSuffix = fileSuffix.trim();
        String resourceViewSuffixes = org.apache.dolphinscheduler.common.utils.FileUtils.getResourceViewSuffixes();
        if (StringUtils.isNotEmpty((CharSequence)resourceViewSuffixes) && !(strList = Arrays.asList(resourceViewSuffixes.split(","))).contains(nameSuffix)) {
            log.warn("Resource suffix does not support view, suffix:{}.", (Object)nameSuffix);
            this.putMsg((Result)result, Status.RESOURCE_SUFFIX_NOT_SUPPORT_VIEW, new Object[0]);
            return result;
        }
        String name = fileName.trim() + "." + nameSuffix;
        String fullName = "";
        String userResRootPath = this.storageOperate.getResDir(tenantCode);
        fullName = !currentDir.contains(userResRootPath) ? userResRootPath + name : currentDir + name;
        result = this.verifyResourceName(fullName, type, loginUser);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        result = this.uploadContentToStorage(loginUser, fullName, tenantCode, content);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            throw new ServiceException(result.getMsg());
        }
        return result;
    }

    @Override
    @Transactional
    public StorageEntity createOrUpdateResource(String userName, String filepath, String resourceContent) throws Exception {
        User user = this.userMapper.queryByUserNameAccurately(userName);
        int suffixLabelIndex = filepath.indexOf(".");
        if (suffixLabelIndex == -1) {
            throw new IllegalArgumentException(String.format("Not allow create or update resources without extension name, filepath: %s", filepath));
        }
        String defaultPath = this.storageOperate.getResDir(user.getTenantCode());
        String fullName = defaultPath + filepath;
        Result<Object> result = this.uploadContentToStorage(user, fullName, user.getTenantCode(), resourceContent);
        if (result.getCode().intValue() != Status.SUCCESS.getCode()) {
            throw new ServiceException(result.getMsg());
        }
        return this.storageOperate.getFileStatus(fullName, defaultPath, user.getTenantCode(), ResourceType.FILE);
    }

    @Override
    @Transactional
    public Result<Object> updateResourceContent(User loginUser, String fullName, String resTenantCode, String content) {
        List<String> strList;
        StorageEntity resource;
        Result<Object> result = new Result<Object>();
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg((Result)result, Status.USER_NOT_EXIST, new Object[]{loginUser.getId()});
            return result;
        }
        String tenantCode = this.getTenantCode(user);
        if (!this.isUserTenantValid(this.isAdmin(loginUser), tenantCode, resTenantCode)) {
            log.error("current user does not have permission");
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        try {
            resource = this.storageOperate.getFileStatus(fullName, "", resTenantCode, ResourceType.FILE);
        }
        catch (Exception e) {
            log.error("error occurred when fetching resource information ,  resource full name {}", (Object)fullName);
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        if (resource == null) {
            log.error("Resource does not exist, resource full name:{}.", (Object)fullName);
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        String nameSuffix = com.google.common.io.Files.getFileExtension((String)resource.getAlias());
        String resourceViewSuffixes = org.apache.dolphinscheduler.common.utils.FileUtils.getResourceViewSuffixes();
        if (StringUtils.isNotEmpty((CharSequence)resourceViewSuffixes) && !(strList = Arrays.asList(resourceViewSuffixes.split(","))).contains(nameSuffix)) {
            log.warn("Resource suffix does not support view, resource full name:{}, suffix:{}.", (Object)fullName, (Object)nameSuffix);
            this.putMsg((Result)result, Status.RESOURCE_SUFFIX_NOT_SUPPORT_VIEW, new Object[0]);
            return result;
        }
        result = this.uploadContentToStorage(loginUser, resource.getFullName(), resTenantCode, content);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            throw new ServiceException(result.getMsg());
        }
        log.info("Update resource content complete, resource full name:{}.", (Object)fullName);
        return result;
    }

    private Result<Object> uploadContentToStorage(User loginUser, String fullName, String tenantCode, String content) {
        Result<Object> result = new Result<Object>();
        String localFilename = "";
        try {
            localFilename = org.apache.dolphinscheduler.common.utils.FileUtils.getUploadFilename((String)tenantCode, (String)UUID.randomUUID().toString());
            if (!org.apache.dolphinscheduler.common.utils.FileUtils.writeContent2File((String)content, (String)localFilename)) {
                log.error("Write file error, fileName:{}, content:{}.", (Object)localFilename, (Object)RegexUtils.escapeNRT(content));
                this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            String resourcePath = this.storageOperate.getResDir(tenantCode);
            log.info("resource  path is {}, resource dir is {}", (Object)fullName, (Object)resourcePath);
            if (!this.storageOperate.exists(resourcePath)) {
                this.storageOperate.createTenantDirIfNotExists(tenantCode);
                log.info("Create tenant dir because path {} does not exist, tenantCode:{}.", (Object)resourcePath, (Object)tenantCode);
            }
            if (this.storageOperate.exists(fullName)) {
                this.storageOperate.delete(fullName, false);
            }
            this.storageOperate.upload(tenantCode, localFilename, fullName, true, true);
        }
        catch (Exception e) {
            log.error("Upload content to storage error, tenantCode:{}, destFileName:{}.", new Object[]{tenantCode, localFilename, e});
            result.setCode(Status.HDFS_OPERATION_ERROR.getCode());
            result.setMsg(String.format("copy %s to hdfs %s fail", localFilename, fullName));
            return result;
        }
        log.info("Upload content to storage complete, tenantCode:{}, destFileName:{}.", (Object)tenantCode, (Object)localFilename);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Resource downloadResource(User loginUser, String fullName) {
        if (fullName.endsWith("/")) {
            log.error("resource id {} is directory,can't download it", (Object)fullName);
            throw new ServiceException("can't download directory");
        }
        int userId = loginUser.getId();
        User user = this.userMapper.selectById(userId);
        if (user == null) {
            log.error("User does not exits, userId:{}.", (Object)userId);
            throw new ServiceException(String.format("Resource owner id %d does not exist", userId));
        }
        String tenantCode = this.getTenantCode(user);
        String[] aliasArr = fullName.split("/");
        String alias = aliasArr[aliasArr.length - 1];
        String localFileName = org.apache.dolphinscheduler.common.utils.FileUtils.getDownloadFilename((String)alias);
        log.info("Resource path is {}, download local filename is {}", (Object)alias, (Object)localFileName);
        try {
            this.storageOperate.download(fullName, localFileName, true);
            ApiServerMetrics.recordApiResourceDownloadSize(Files.size(Paths.get(localFileName, new String[0])));
            return FileUtils.file2Resource(localFileName);
        }
        catch (IOException e) {
            log.error("Download resource error, the path is {}, and local filename is {}, the error message is {}", new Object[]{fullName, localFileName, e.getMessage()});
            throw new ServiceException("Download the resource file failed ,it may be related to your storage");
        }
    }

    @Override
    public StorageEntity queryFileStatus(String userName, String fileName) throws Exception {
        User user = this.userMapper.queryByUserNameAccurately(userName);
        String defaultPath = this.storageOperate.getResDir(user.getTenantCode());
        return this.storageOperate.getFileStatus(defaultPath + fileName, defaultPath, user.getTenantCode(), ResourceType.FILE);
    }

    @Override
    public DeleteDataTransferResponse deleteDataTransferData(User loginUser, Integer days) {
        ArrayList storageEntities;
        DeleteDataTransferResponse result = new DeleteDataTransferResponse();
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg((Result)result, Status.USER_NOT_EXIST, new Object[]{loginUser.getId()});
            return result;
        }
        String tenantCode = this.getTenantCode(user);
        String baseFolder = this.storageOperate.getResourceFullName(tenantCode, "DATA_TRANSFER");
        LocalDateTime now = LocalDateTime.now();
        now = now.minus(days.intValue(), ChronoUnit.DAYS);
        String deleteDate = now.toLocalDate().toString().replace("-", "");
        try {
            storageEntities = new ArrayList(this.storageOperate.listFilesStatus(baseFolder, baseFolder, tenantCode, ResourceType.FILE));
        }
        catch (Exception e) {
            log.error("delete data transfer data error", (Throwable)e);
            this.putMsg((Result)result, Status.DELETE_RESOURCE_ERROR, new Object[0]);
            return result;
        }
        ArrayList<String> successList = new ArrayList<String>();
        ArrayList<String> failList = new ArrayList<String>();
        for (StorageEntity storageEntity : storageEntities) {
            File path = new File(storageEntity.getFullName());
            String date = path.getName();
            if (date.compareTo(deleteDate) > 0) continue;
            try {
                this.storageOperate.delete(storageEntity.getFullName(), true);
                successList.add(storageEntity.getFullName());
            }
            catch (Exception ex) {
                log.error("delete data transfer data {} error, please delete it manually", (Object)date, (Object)ex);
                failList.add(storageEntity.getFullName());
            }
        }
        result.setSuccessList(successList);
        result.setFailedList(failList);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> unauthorizedUDFFunction(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        List udfFuncList = this.isAdmin(loginUser) ? this.udfFunctionMapper.queryUdfFuncExceptUserId(userId.intValue()) : this.udfFunctionMapper.selectByMap(Collections.singletonMap("user_id", loginUser.getId()));
        ArrayList resultList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)udfFuncList)) {
            HashSet udfFuncSet = new HashSet(udfFuncList);
            List authedUDFFuncList = this.udfFunctionMapper.queryAuthedUdfFunc(userId.intValue());
            this.getAuthorizedResourceList(udfFuncSet, authedUDFFuncList);
            resultList = new ArrayList(udfFuncSet);
        }
        result.put("data", resultList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> authorizedUDFFunction(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        List udfFuncs = this.udfFunctionMapper.queryAuthedUdfFunc(userId.intValue());
        result.put("data", udfFuncs);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> queryResourceBaseDir(User loginUser, ResourceType type) {
        Result<Object> result = new Result<Object>();
        if (this.storageOperate == null) {
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
            result.setData("");
            return result;
        }
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            log.error("user {} not exists", (Object)loginUser.getId());
            this.putMsg((Result)result, Status.USER_NOT_EXIST, new Object[]{loginUser.getId()});
            return result;
        }
        String tenantCode = this.getTenantCode(user);
        if (!this.isUserTenantValid(this.isAdmin(loginUser), tenantCode, "")) {
            log.error("current user does not have permission");
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        String baseDir = this.isAdmin(loginUser) ? this.storageOperate.getDir(ResourceType.ALL, tenantCode) : this.storageOperate.getDir(type, tenantCode);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        result.setData(baseDir);
        return result;
    }

    private void getAuthorizedResourceList(Set<?> resourceSet, List<?> authedResourceList) {
        if (CollectionUtils.isNotEmpty(authedResourceList)) {
            HashSet authedResourceSet = new HashSet(authedResourceList);
            resourceSet.removeAll(authedResourceSet);
        }
    }

    private AuthorizationType checkResourceType(ResourceType type) {
        return type.equals((Object)ResourceType.FILE) ? AuthorizationType.RESOURCE_FILE_ID : AuthorizationType.UDF_FILE;
    }

    private boolean isUserTenantValid(boolean isAdmin, String userTenantCode, String resTenantCode) throws ServiceException {
        if (!isAdmin) {
            String string = resTenantCode = resTenantCode == null ? "" : resTenantCode;
            if (!StringUtils.isBlank((CharSequence)resTenantCode) && !resTenantCode.equals(userTenantCode)) {
                return false;
            }
        }
        return true;
    }

    private String getTenantCode(User user) {
        Tenant tenant = this.tenantMapper.queryById(user.getTenantId());
        if (tenant == null) {
            throw new ServiceException(Status.CURRENT_LOGIN_USER_TENANT_NOT_EXIST);
        }
        return tenant.getTenantCode();
    }
}

