/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.api.service.MonitorService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.model.WorkerServerModel;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.plugin.api.monitor.DatabaseMetrics;
import org.apache.dolphinscheduler.dao.plugin.api.monitor.DatabaseMonitor;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitorServiceImpl
extends BaseServiceImpl
implements MonitorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitorServiceImpl.class);
    @Autowired
    private DatabaseMonitor databaseMonitor;
    @Autowired
    private RegistryClient registryClient;

    @Override
    public List<DatabaseMetrics> queryDatabaseState(User loginUser) {
        return Lists.newArrayList((Object[])new DatabaseMetrics[]{this.databaseMonitor.getDatabaseMetrics()});
    }

    @Override
    public List<Server> queryMaster(User loginUser) {
        return this.registryClient.getServerList(RegistryNodeType.MASTER);
    }

    @Override
    public List<WorkerServerModel> queryWorker(User loginUser) {
        return this.registryClient.getServerList(RegistryNodeType.WORKER).stream().map(server -> {
            WorkerServerModel model = new WorkerServerModel();
            model.setId(server.getId());
            model.setHost(server.getHost());
            model.setPort(server.getPort());
            model.setZkDirectories((Set)Sets.newHashSet((Object[])new String[]{server.getZkDirectory()}));
            model.setResInfo(server.getResInfo());
            model.setCreateTime(server.getCreateTime());
            model.setLastHeartbeatTime(server.getLastHeartbeatTime());
            return model;
        }).collect(Collectors.toList());
    }

    @Override
    public List<Server> getServerListFromRegistry(boolean isMaster) {
        return isMaster ? this.registryClient.getServerList(RegistryNodeType.MASTER) : this.registryClient.getServerList(RegistryNodeType.WORKER);
    }
}

