/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.AlertGroupService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.dao.entity.AlertGroup;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.AlertGroupMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AlertGroupServiceImpl
extends BaseServiceImpl
implements AlertGroupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertGroupServiceImpl.class);
    @Autowired
    private AlertGroupMapper alertGroupMapper;

    @Override
    public List<AlertGroup> queryAllAlertGroup(User loginUser) {
        if (loginUser.getUserType().equals((Object)UserType.ADMIN_USER)) {
            return this.alertGroupMapper.queryAllGroupList();
        }
        Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.ALERT_GROUP, loginUser.getId(), log);
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.alertGroupMapper.selectBatchIds(ids);
    }

    @Override
    public List<AlertGroup> queryNormalAlertGroups(User loginUser) {
        return this.queryAllAlertGroup(loginUser).stream().filter(alertGroup -> alertGroup.getId() != 2).collect(Collectors.toList());
    }

    @Override
    public AlertGroup queryAlertGroupById(User loginUser, Integer id) {
        if (!this.canOperatorPermissions(loginUser, new Object[]{id}, AuthorizationType.ALERT_GROUP, "security:alert-group:view")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        AlertGroup alertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)id);
        if (alertGroup == null) {
            throw new ServiceException(Status.ALERT_GROUP_NOT_EXIST, id);
        }
        return alertGroup;
    }

    @Override
    public PageInfo<AlertGroup> listPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if (loginUser.getUserType().equals((Object)UserType.ADMIN_USER)) {
            IPage alertGroupIPage = this.alertGroupMapper.queryAlertGroupPage(page, searchVal);
            return PageInfo.of(alertGroupIPage);
        }
        Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.ALERT_GROUP, loginUser.getId(), log);
        if (ids.isEmpty()) {
            return PageInfo.of(pageNo, pageSize);
        }
        IPage alertGroupIPage = this.alertGroupMapper.queryAlertGroupPageByIds(page, new ArrayList(ids), searchVal);
        return PageInfo.of(alertGroupIPage);
    }

    @Override
    @Transactional
    public AlertGroup createAlertGroup(User loginUser, String groupName, String desc, String alertInstanceIds) {
        HashMap result = new HashMap();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.ALERT_GROUP, "security:alert-group:create")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        if (this.checkDescriptionLength(desc)) {
            log.warn("Parameter description is too long.");
            throw new ServiceException(Status.DESCRIPTION_TOO_LONG_ERROR);
        }
        AlertGroup alertGroup = new AlertGroup();
        Date now = new Date();
        alertGroup.setGroupName(groupName);
        alertGroup.setAlertInstanceIds(alertInstanceIds);
        alertGroup.setDescription(desc);
        alertGroup.setCreateTime(now);
        alertGroup.setUpdateTime(now);
        alertGroup.setCreateUserId(loginUser.getId().intValue());
        try {
            int insert = this.alertGroupMapper.insert((Object)alertGroup);
            if (insert > 0) {
                log.info("Create alert group complete, groupName:{}", (Object)alertGroup.getGroupName());
                return alertGroup;
            }
            log.error("Create alert group error, groupName:{}", (Object)alertGroup.getGroupName());
            throw new ServiceException(Status.CREATE_ALERT_GROUP_ERROR);
        }
        catch (DuplicateKeyException ex) {
            log.error("Create alert group error, groupName:{}", (Object)alertGroup.getGroupName(), (Object)ex);
            throw new ServiceException(Status.ALERT_GROUP_EXIST);
        }
    }

    @Override
    public AlertGroup updateAlertGroupById(User loginUser, int id, String groupName, String desc, String alertInstanceIds) {
        if (id == 2) {
            throw new ServiceException(Status.NOT_ALLOW_TO_UPDATE_GLOBAL_ALARM_GROUP);
        }
        if (!this.canOperatorPermissions(loginUser, new Object[]{id}, AuthorizationType.ALERT_GROUP, "security:alert-group:update")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        if (this.checkDescriptionLength(desc)) {
            throw new ServiceException(Status.DESCRIPTION_TOO_LONG_ERROR);
        }
        AlertGroup alertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (alertGroup == null) {
            throw new ServiceException(Status.ALERT_GROUP_NOT_EXIST);
        }
        Date now = new Date();
        if (!StringUtils.isEmpty((CharSequence)groupName)) {
            alertGroup.setGroupName(groupName);
        }
        alertGroup.setDescription(desc);
        alertGroup.setUpdateTime(now);
        alertGroup.setCreateUserId(loginUser.getId().intValue());
        alertGroup.setAlertInstanceIds(alertInstanceIds);
        try {
            this.alertGroupMapper.updateById((Object)alertGroup);
            log.info("Update alert group complete, groupName:{}", (Object)alertGroup.getGroupName());
            return alertGroup;
        }
        catch (DuplicateKeyException ex) {
            log.error("Update alert group error, groupName:{}", (Object)alertGroup.getGroupName(), (Object)ex);
            throw new ServiceException(Status.ALERT_GROUP_EXIST);
        }
    }

    @Override
    public void deleteAlertGroupById(User loginUser, int id) {
        if (!this.canOperatorPermissions(loginUser, new Object[]{id}, AuthorizationType.ALERT_GROUP, "security:alert-group:delete")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        if (id == 1 || id == 2) {
            log.warn("Not allow to delete the default alarm group.");
            throw new ServiceException(Status.NOT_ALLOW_TO_DELETE_DEFAULT_ALARM_GROUP);
        }
        AlertGroup alertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (alertGroup == null) {
            throw new ServiceException(Status.ALERT_GROUP_NOT_EXIST);
        }
        this.alertGroupMapper.deleteById((Serializable)Integer.valueOf(id));
        log.info("Delete alert group complete, groupId:{}", (Object)id);
    }

    @Override
    public boolean existGroupName(String groupName) {
        return this.alertGroupMapper.existGroupName(groupName) == Boolean.TRUE;
    }
}

