/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.security.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.security.AuthenticationType;
import org.apache.dolphinscheduler.api.security.Authenticator;
import org.apache.dolphinscheduler.api.security.SecurityConfig;
import org.apache.dolphinscheduler.api.service.SessionService;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.dao.entity.Session;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.util.WebUtils;

public abstract class AbstractAuthenticator
implements Authenticator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthenticator.class);
    @Autowired
    protected UsersService userService;
    @Autowired
    private SessionService sessionService;
    @Autowired
    private SecurityConfig securityConfig;

    public abstract User login(@NonNull String var1, String var2);

    @Override
    public Result<Map<String, String>> authenticate(@NonNull String userId, String password, @NonNull String ip) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (ip == null) {
            throw new NullPointerException("ip is marked non-null but is null");
        }
        Result<Map<String, String>> result = new Result<Map<String, String>>();
        User user = this.login(userId, password);
        if (user == null) {
            if (Objects.equals(this.securityConfig.getType(), AuthenticationType.CASDOOR_SSO.name())) {
                log.error("State or code entered incorrectly.");
                result.setCode(Status.STATE_CODE_ERROR.getCode());
                result.setMsg(Status.STATE_CODE_ERROR.getMsg());
            } else {
                log.error("Username or password entered incorrectly.");
                result.setCode(Status.USER_NAME_PASSWD_ERROR.getCode());
                result.setMsg(Status.USER_NAME_PASSWD_ERROR.getMsg());
            }
            return result;
        }
        if (user.getState() == Flag.NO.ordinal()) {
            log.error("The current user is deactivated, userName:{}.", (Object)user.getUserName());
            result.setCode(Status.USER_DISABLED.getCode());
            result.setMsg(Status.USER_DISABLED.getMsg());
            return result;
        }
        Session session = this.sessionService.createSessionIfAbsent(user);
        if (session == null) {
            result.setCode(Status.LOGIN_SESSION_FAILED.getCode());
            result.setMsg(Status.LOGIN_SESSION_FAILED.getMsg());
            return result;
        }
        log.info("Session is created, userName:{}.", (Object)user.getUserName());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sessionId", session.getId());
        data.put("securityConfigType", this.securityConfig.getType());
        result.setData(data);
        result.setCode(Status.SUCCESS.getCode());
        result.setMsg(Status.LOGIN_SUCCESS.getMsg());
        return result;
    }

    @Override
    public User getAuthUser(HttpServletRequest request) {
        Session session;
        Cookie cookie;
        String sessionId = request.getHeader("sessionId");
        if (StringUtils.isBlank((CharSequence)sessionId) && (cookie = WebUtils.getCookie((HttpServletRequest)request, (String)"sessionId")) != null) {
            sessionId = cookie.getValue();
        }
        if ((session = this.sessionService.getSession(sessionId)) == null) {
            return null;
        }
        return this.userService.queryUser(session.getUserId());
    }
}

