/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow.instance.pause.recover;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.executor.ExecuteFunction;
import org.apache.dolphinscheduler.api.executor.ExecuteRuntimeException;
import org.apache.dolphinscheduler.api.executor.workflow.instance.pause.recover.RecoverExecuteFunctionBuilder;
import org.apache.dolphinscheduler.api.executor.workflow.instance.pause.recover.RecoverExecuteRequest;
import org.apache.dolphinscheduler.api.executor.workflow.instance.pause.recover.RecoverExecuteResult;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.service.command.CommandService;

public class RecoverExecuteFunction
implements ExecuteFunction<RecoverExecuteRequest, RecoverExecuteResult> {
    private final CommandService commandService;

    public RecoverExecuteFunction(CommandService commandService) {
        this.commandService = commandService;
    }

    @Override
    public RecoverExecuteResult execute(RecoverExecuteRequest request) throws ExecuteRuntimeException {
        ProcessInstance workflowInstance = request.getWorkflowInstance();
        if (!workflowInstance.getState().isPause()) {
            throw new ExecuteRuntimeException(String.format("The workflow instance: %s state is %s, cannot recovery", workflowInstance.getName(), workflowInstance.getState()));
        }
        Command command = Command.builder().commandType(CommandType.RECOVER_SUSPENDED_PROCESS).processDefinitionCode(workflowInstance.getProcessDefinitionCode().longValue()).processDefinitionVersion(workflowInstance.getProcessDefinitionVersion()).processInstanceId(workflowInstance.getId().intValue()).commandParam(JSONUtils.toJsonString(this.createCommandParam(workflowInstance))).executorId(request.getExecuteUser().getId().intValue()).testFlag(workflowInstance.getTestFlag()).build();
        if (this.commandService.createCommand(command) <= 0) {
            throw new ExecuteRuntimeException(String.format("Recovery workflow instance: %s failed, due to insert command to db failed", workflowInstance.getName()));
        }
        return new RecoverExecuteResult(command);
    }

    private Map<String, Object> createCommandParam(ProcessInstance workflowInstance) {
        return new ImmutableMap.Builder().put((Object)"ProcessInstanceId", (Object)workflowInstance.getId()).build();
    }

    @Override
    public ExecuteType getExecuteType() {
        return RecoverExecuteFunctionBuilder.EXECUTE_TYPE;
    }
}

