/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.taskRelation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.apache.dolphinscheduler.api.dto.PageQueryDto;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;

@Schema(name="TASK-RELATION-QUERY")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TaskRelationFilterRequest
extends PageQueryDto {
    @Schema(example="1234567890123")
    private long workflowCode;
    @Schema(example="1234567890123")
    private long preTaskCode;
    @Schema(example="1234567890123")
    private long postTaskCode;

    public TaskRelationFilterRequest(long workflowCode, long preTaskCode, long postTaskCode) {
        this.workflowCode = workflowCode;
        this.preTaskCode = preTaskCode;
        this.postTaskCode = postTaskCode;
    }

    public TaskRelationFilterRequest(long preTaskCode, long postTaskCode) {
        this.preTaskCode = preTaskCode;
        this.postTaskCode = postTaskCode;
    }

    public ProcessTaskRelation convert2TaskDefinition() {
        ProcessTaskRelation processTaskRelation = new ProcessTaskRelation();
        if (this.workflowCode != 0L) {
            processTaskRelation.setProcessDefinitionCode(this.workflowCode);
        }
        if (this.preTaskCode != 0L) {
            processTaskRelation.setPreTaskCode(this.preTaskCode);
        }
        if (this.postTaskCode != 0L) {
            processTaskRelation.setPostTaskCode(this.postTaskCode);
        }
        return processTaskRelation;
    }

    @Generated
    public long getWorkflowCode() {
        return this.workflowCode;
    }

    @Generated
    public long getPreTaskCode() {
        return this.preTaskCode;
    }

    @Generated
    public long getPostTaskCode() {
        return this.postTaskCode;
    }

    @Generated
    public void setWorkflowCode(long workflowCode) {
        this.workflowCode = workflowCode;
    }

    @Generated
    public void setPreTaskCode(long preTaskCode) {
        this.preTaskCode = preTaskCode;
    }

    @Generated
    public void setPostTaskCode(long postTaskCode) {
        this.postTaskCode = postTaskCode;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskRelationFilterRequest)) {
            return false;
        }
        TaskRelationFilterRequest other = (TaskRelationFilterRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWorkflowCode() != other.getWorkflowCode()) {
            return false;
        }
        if (this.getPreTaskCode() != other.getPreTaskCode()) {
            return false;
        }
        return this.getPostTaskCode() == other.getPostTaskCode();
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskRelationFilterRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $workflowCode = this.getWorkflowCode();
        result = result * 59 + (int)($workflowCode >>> 32 ^ $workflowCode);
        long $preTaskCode = this.getPreTaskCode();
        result = result * 59 + (int)($preTaskCode >>> 32 ^ $preTaskCode);
        long $postTaskCode = this.getPostTaskCode();
        result = result * 59 + (int)($postTaskCode >>> 32 ^ $postTaskCode);
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TaskRelationFilterRequest(workflowCode=" + this.getWorkflowCode() + ", preTaskCode=" + this.getPreTaskCode() + ", postTaskCode=" + this.getPostTaskCode() + ")";
    }
}

