/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.schedule;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.api.dto.schedule.ScheduleParam;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.Schedule;

public class ScheduleCreateRequest {
    @Schema(example="1234567890123", required=true)
    private long processDefinitionCode;
    @Schema(example="schedule timezone", required=true)
    private String crontab;
    @Schema(example="2021-01-01 10:00:00", required=true)
    private String startTime;
    @Schema(example="2022-01-01 12:00:00", required=true)
    private String endTime;
    @Schema(example="Asia/Shanghai", required=true)
    private String timezoneId;
    @Schema(allowableValues={"CONTINUE / END"}, example="CONTINUE", description="default CONTINUE if value not provide.")
    private String failureStrategy;
    @Schema(allowableValues={"ONLINE / OFFLINE"}, example="OFFLINE", description="default OFFLINE if value not provide.")
    private String releaseState;
    @Schema(allowableValues={"NONE / SUCCESS / FAILURE / ALL"}, example="SUCCESS", description="default NONE if value not provide.")
    private String warningType;
    @Schema(example="2", description="default 0 if value not provide.")
    private int warningGroupId;
    @Schema(allowableValues={"HIGHEST / HIGH / MEDIUM / LOW / LOWEST"}, example="MEDIUM", description="default MEDIUM if value not provide.")
    private String processInstancePriority;
    @Schema(example="worker-group-name")
    private String workerGroup;
    @Schema(example="tenant-code")
    private String tenantCode;
    @Schema(example="environment-code")
    private long environmentCode;

    public String getScheduleParam() {
        Gson gson = new GsonBuilder().serializeNulls().create();
        ScheduleParam scheduleParam = new ScheduleParam(this.startTime, this.endTime, this.crontab, this.timezoneId);
        return gson.toJson((Object)scheduleParam);
    }

    public Schedule convert2Schedule() {
        Schedule schedule = new Schedule();
        schedule.setProcessDefinitionCode(this.processDefinitionCode);
        schedule.setCrontab(this.crontab);
        schedule.setStartTime(DateUtils.stringToDate((String)this.startTime));
        schedule.setEndTime(DateUtils.stringToDate((String)this.endTime));
        schedule.setTimezoneId(this.timezoneId);
        schedule.setWarningGroupId(this.warningGroupId);
        schedule.setWorkerGroup(this.workerGroup);
        schedule.setTenantCode(this.tenantCode);
        schedule.setEnvironmentCode(Long.valueOf(this.environmentCode));
        FailureStrategy newFailureStrategy = this.failureStrategy == null ? FailureStrategy.CONTINUE : FailureStrategy.valueOf((String)this.failureStrategy);
        schedule.setFailureStrategy(newFailureStrategy);
        ReleaseState newReleaseState = this.releaseState == null ? ReleaseState.OFFLINE : ReleaseState.valueOf((String)this.releaseState);
        schedule.setReleaseState(newReleaseState);
        WarningType newWarningType = this.warningType == null ? WarningType.NONE : WarningType.valueOf((String)this.warningType);
        schedule.setWarningType(newWarningType);
        Priority newPriority = this.processInstancePriority == null ? Priority.MEDIUM : Priority.valueOf((String)this.processInstancePriority);
        schedule.setProcessInstancePriority(newPriority);
        Date date = new Date();
        schedule.setCreateTime(date);
        schedule.setUpdateTime(date);
        return schedule;
    }

    @Generated
    public ScheduleCreateRequest() {
    }

    @Generated
    public long getProcessDefinitionCode() {
        return this.processDefinitionCode;
    }

    @Generated
    public String getCrontab() {
        return this.crontab;
    }

    @Generated
    public String getStartTime() {
        return this.startTime;
    }

    @Generated
    public String getEndTime() {
        return this.endTime;
    }

    @Generated
    public String getTimezoneId() {
        return this.timezoneId;
    }

    @Generated
    public String getFailureStrategy() {
        return this.failureStrategy;
    }

    @Generated
    public String getReleaseState() {
        return this.releaseState;
    }

    @Generated
    public String getWarningType() {
        return this.warningType;
    }

    @Generated
    public int getWarningGroupId() {
        return this.warningGroupId;
    }

    @Generated
    public String getProcessInstancePriority() {
        return this.processInstancePriority;
    }

    @Generated
    public String getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public String getTenantCode() {
        return this.tenantCode;
    }

    @Generated
    public long getEnvironmentCode() {
        return this.environmentCode;
    }

    @Generated
    public void setProcessDefinitionCode(long processDefinitionCode) {
        this.processDefinitionCode = processDefinitionCode;
    }

    @Generated
    public void setCrontab(String crontab) {
        this.crontab = crontab;
    }

    @Generated
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setTimezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
    }

    @Generated
    public void setFailureStrategy(String failureStrategy) {
        this.failureStrategy = failureStrategy;
    }

    @Generated
    public void setReleaseState(String releaseState) {
        this.releaseState = releaseState;
    }

    @Generated
    public void setWarningType(String warningType) {
        this.warningType = warningType;
    }

    @Generated
    public void setWarningGroupId(int warningGroupId) {
        this.warningGroupId = warningGroupId;
    }

    @Generated
    public void setProcessInstancePriority(String processInstancePriority) {
        this.processInstancePriority = processInstancePriority;
    }

    @Generated
    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    @Generated
    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    @Generated
    public void setEnvironmentCode(long environmentCode) {
        this.environmentCode = environmentCode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduleCreateRequest)) {
            return false;
        }
        ScheduleCreateRequest other = (ScheduleCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProcessDefinitionCode() != other.getProcessDefinitionCode()) {
            return false;
        }
        if (this.getWarningGroupId() != other.getWarningGroupId()) {
            return false;
        }
        if (this.getEnvironmentCode() != other.getEnvironmentCode()) {
            return false;
        }
        String this$crontab = this.getCrontab();
        String other$crontab = other.getCrontab();
        if (this$crontab == null ? other$crontab != null : !this$crontab.equals(other$crontab)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        String this$timezoneId = this.getTimezoneId();
        String other$timezoneId = other.getTimezoneId();
        if (this$timezoneId == null ? other$timezoneId != null : !this$timezoneId.equals(other$timezoneId)) {
            return false;
        }
        String this$failureStrategy = this.getFailureStrategy();
        String other$failureStrategy = other.getFailureStrategy();
        if (this$failureStrategy == null ? other$failureStrategy != null : !this$failureStrategy.equals(other$failureStrategy)) {
            return false;
        }
        String this$releaseState = this.getReleaseState();
        String other$releaseState = other.getReleaseState();
        if (this$releaseState == null ? other$releaseState != null : !this$releaseState.equals(other$releaseState)) {
            return false;
        }
        String this$warningType = this.getWarningType();
        String other$warningType = other.getWarningType();
        if (this$warningType == null ? other$warningType != null : !this$warningType.equals(other$warningType)) {
            return false;
        }
        String this$processInstancePriority = this.getProcessInstancePriority();
        String other$processInstancePriority = other.getProcessInstancePriority();
        if (this$processInstancePriority == null ? other$processInstancePriority != null : !this$processInstancePriority.equals(other$processInstancePriority)) {
            return false;
        }
        String this$workerGroup = this.getWorkerGroup();
        String other$workerGroup = other.getWorkerGroup();
        if (this$workerGroup == null ? other$workerGroup != null : !this$workerGroup.equals(other$workerGroup)) {
            return false;
        }
        String this$tenantCode = this.getTenantCode();
        String other$tenantCode = other.getTenantCode();
        return !(this$tenantCode == null ? other$tenantCode != null : !this$tenantCode.equals(other$tenantCode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScheduleCreateRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $processDefinitionCode = this.getProcessDefinitionCode();
        result = result * 59 + (int)($processDefinitionCode >>> 32 ^ $processDefinitionCode);
        result = result * 59 + this.getWarningGroupId();
        long $environmentCode = this.getEnvironmentCode();
        result = result * 59 + (int)($environmentCode >>> 32 ^ $environmentCode);
        String $crontab = this.getCrontab();
        result = result * 59 + ($crontab == null ? 43 : $crontab.hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        String $timezoneId = this.getTimezoneId();
        result = result * 59 + ($timezoneId == null ? 43 : $timezoneId.hashCode());
        String $failureStrategy = this.getFailureStrategy();
        result = result * 59 + ($failureStrategy == null ? 43 : $failureStrategy.hashCode());
        String $releaseState = this.getReleaseState();
        result = result * 59 + ($releaseState == null ? 43 : $releaseState.hashCode());
        String $warningType = this.getWarningType();
        result = result * 59 + ($warningType == null ? 43 : $warningType.hashCode());
        String $processInstancePriority = this.getProcessInstancePriority();
        result = result * 59 + ($processInstancePriority == null ? 43 : $processInstancePriority.hashCode());
        String $workerGroup = this.getWorkerGroup();
        result = result * 59 + ($workerGroup == null ? 43 : $workerGroup.hashCode());
        String $tenantCode = this.getTenantCode();
        result = result * 59 + ($tenantCode == null ? 43 : $tenantCode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScheduleCreateRequest(processDefinitionCode=" + this.getProcessDefinitionCode() + ", crontab=" + this.getCrontab() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", timezoneId=" + this.getTimezoneId() + ", failureStrategy=" + this.getFailureStrategy() + ", releaseState=" + this.getReleaseState() + ", warningType=" + this.getWarningType() + ", warningGroupId=" + this.getWarningGroupId() + ", processInstancePriority=" + this.getProcessInstancePriority() + ", workerGroup=" + this.getWorkerGroup() + ", tenantCode=" + this.getTenantCode() + ", environmentCode=" + this.getEnvironmentCode() + ")";
    }
}

