/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.resources.visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.dolphinscheduler.api.dto.resources.Directory;
import org.apache.dolphinscheduler.api.dto.resources.FileLeaf;
import org.apache.dolphinscheduler.api.dto.resources.ResourceComponent;
import org.apache.dolphinscheduler.api.dto.resources.visitor.Visitor;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;

public class ResourceTreeVisitor
implements Visitor {
    private List<StorageEntity> resourceList;

    public ResourceTreeVisitor() {
    }

    public ResourceTreeVisitor(List<StorageEntity> resourceList) {
        this.resourceList = resourceList;
    }

    @Override
    public ResourceComponent visit(String rootPath) {
        Directory rootDirectory = new Directory();
        for (StorageEntity resource : this.resourceList) {
            if (!this.rootNode(resource, rootPath)) continue;
            ResourceComponent tempResourceComponent = ResourceTreeVisitor.getResourceComponent(resource);
            rootDirectory.add(tempResourceComponent);
            tempResourceComponent.setChildren(ResourceTreeVisitor.setChildren(tempResourceComponent.getFullName(), this.resourceList));
        }
        return rootDirectory;
    }

    public static List<ResourceComponent> setChildren(String fullName, List<StorageEntity> list) {
        ArrayList<ResourceComponent> childList = new ArrayList<ResourceComponent>();
        for (StorageEntity resource : list) {
            if (!Objects.equals(fullName, resource.getPfullName())) continue;
            ResourceComponent tempResourceComponent = ResourceTreeVisitor.getResourceComponent(resource);
            childList.add(tempResourceComponent);
        }
        for (ResourceComponent resourceComponent : childList) {
            resourceComponent.setChildren(ResourceTreeVisitor.setChildren(resourceComponent.getFullName(), list));
        }
        if (childList.size() == 0) {
            return new ArrayList<ResourceComponent>();
        }
        return childList;
    }

    public boolean rootNode(StorageEntity resource, String rootPath) {
        boolean isRootNode = true;
        if (!Objects.equals(resource.getPfullName(), rootPath)) {
            for (StorageEntity parent : this.resourceList) {
                if (!Objects.equals(resource.getPfullName(), parent.getFullName())) continue;
                isRootNode = false;
                break;
            }
        }
        return isRootNode;
    }

    private static ResourceComponent getResourceComponent(StorageEntity resource) {
        ResourceComponent tempResourceComponent = resource.isDirectory() ? new Directory() : new FileLeaf();
        tempResourceComponent.setName(resource.getAlias());
        tempResourceComponent.setFullName(resource.getFullName());
        tempResourceComponent.setId(resource.getId());
        tempResourceComponent.setPid(resource.getPfullName());
        tempResourceComponent.setIdValue(resource.getId(), resource.isDirectory());
        tempResourceComponent.setType(resource.getType());
        return tempResourceComponent;
    }
}

