/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.WorkerGroupService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="WORKER_GROUP_TAG")
@RestController
@RequestMapping(value={"/worker-groups"})
public class WorkerGroupController
extends BaseController {
    @Autowired
    WorkerGroupService workerGroupService;

    @Operation(summary="saveWorkerGroup", description="CREATE_WORKER_GROUP_NOTES")
    @Parameters(value={@Parameter(name="id", description="WORKER_GROUP_ID", schema=@Schema(implementation=int.class, example="10", defaultValue="0")), @Parameter(name="name", description="WORKER_GROUP_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="addrList", description="WORKER_ADDR_LIST", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="description", description="WORKER_DESC", required=false, schema=@Schema(implementation=String.class)), @Parameter(name="otherParamsJson", description="WORKER_PARAMS_JSON", required=false, schema=@Schema(implementation=String.class))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.SAVE_ERROR)
    public Result saveWorkerGroup(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id", required=false, defaultValue="0") int id, @RequestParam(value="name") String name, @RequestParam(value="addrList") String addrList, @RequestParam(value="description", required=false, defaultValue="") String description, @RequestParam(value="otherParamsJson", required=false, defaultValue="") String otherParamsJson) {
        Map<String, Object> result = this.workerGroupService.saveWorkerGroup(loginUser, id, name, addrList, description, otherParamsJson);
        return this.returnDataList(result);
    }

    @Operation(summary="queryAllWorkerGroupsPaging", description="QUERY_WORKER_GROUP_PAGING_NOTES")
    @Parameters(value={@Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20")), @Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_WORKER_GROUP_FAIL)
    public Result queryAllWorkerGroupsPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="searchVal", required=false) String searchVal) {
        this.checkPageParams(pageNo, pageSize);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.workerGroupService.queryAllGroupPaging(loginUser, pageNo, pageSize, searchVal);
    }

    @Operation(summary="queryAllWorkerGroups", description="QUERY_WORKER_GROUP_LIST_NOTES")
    @GetMapping(value={"/all"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_WORKER_GROUP_FAIL)
    public Result queryAllWorkerGroups(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.workerGroupService.queryAllGroup(loginUser);
        return this.returnDataList(result);
    }

    @Operation(summary="deleteWorkerGroupById", description="DELETE_WORKER_GROUP_BY_ID_NOTES")
    @Parameters(value={@Parameter(name="id", description="WORKER_GROUP_ID", required=true, schema=@Schema(implementation=int.class, example="10"))})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_WORKER_GROUP_FAIL)
    public Result deleteWorkerGroupById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") Integer id) {
        Map<String, Object> result = this.workerGroupService.deleteWorkerGroupById(loginUser, id);
        return this.returnDataList(result);
    }

    @Operation(summary="queryWorkerAddressList", description="QUERY_WORKER_ADDRESS_LIST_NOTES")
    @GetMapping(value={"/worker-address-list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_WORKER_ADDRESS_LIST_FAIL)
    public Result queryWorkerAddressList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.workerGroupService.getWorkerAddressList();
        return this.returnDataList(result);
    }
}

