/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="USERS_TAG")
@RestController
@RequestMapping(value={"/users"})
public class UsersController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UsersController.class);
    @Autowired
    private UsersService usersService;

    @Operation(summary="createUser", description="CREATE_USER_NOTES")
    @Parameters(value={@Parameter(name="userName", description="USER_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="userPassword", description="USER_PASSWORD", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="tenantId", description="TENANT_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="queue", description="QUEUE", schema=@Schema(implementation=String.class)), @Parameter(name="email", description="EMAIL", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="phone", description="PHONE", schema=@Schema(implementation=String.class)), @Parameter(name="state", description="STATE", schema=@Schema(implementation=int.class, example="1"))})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_USER_ERROR)
    public Result createUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userName") String userName, @RequestParam(value="userPassword") String userPassword, @RequestParam(value="tenantId") int tenantId, @RequestParam(value="queue", required=false, defaultValue="") String queue, @RequestParam(value="email") String email, @RequestParam(value="phone", required=false) String phone, @RequestParam(value="state", required=false) int state) throws Exception {
        Result<Object> verifyRet = this.usersService.verifyUserName(userName);
        if (verifyRet.getCode().intValue() != Status.SUCCESS.getCode()) {
            return verifyRet;
        }
        Map<String, Object> result = this.usersService.createUser(loginUser, userName, userPassword, email, tenantId, phone, queue, state);
        return this.returnDataList(result);
    }

    @Operation(summary="queryUserList", description="QUERY_USER_LIST_NOTES")
    @Parameters(value={@Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="10")), @Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_USER_LIST_PAGING_ERROR)
    public Result queryUserList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="searchVal", required=false) String searchVal) {
        this.checkPageParams(pageNo, pageSize);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.usersService.queryUserList(loginUser, searchVal, pageNo, pageSize);
    }

    @Operation(summary="updateUser", description="UPDATE_USER_NOTES")
    @Parameters(value={@Parameter(name="id", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="userName", description="USER_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="userPassword", description="USER_PASSWORD", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="tenantId", description="TENANT_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="queue", description="QUEUE", schema=@Schema(implementation=String.class)), @Parameter(name="email", description="EMAIL", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="phone", description="PHONE", schema=@Schema(implementation=String.class)), @Parameter(name="state", description="STATE", schema=@Schema(implementation=int.class, example="1"))})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_USER_ERROR)
    public Result<User> updateUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id, @RequestParam(value="userName") String userName, @RequestParam(value="userPassword") String userPassword, @RequestParam(value="queue", required=false, defaultValue="") String queue, @RequestParam(value="email") String email, @RequestParam(value="tenantId") int tenantId, @RequestParam(value="phone", required=false) String phone, @RequestParam(value="state", required=false) int state, @RequestParam(value="timeZone", required=false) String timeZone) throws Exception {
        User user = this.usersService.updateUser(loginUser, id, userName, userPassword, email, tenantId, phone, queue, state, timeZone);
        return Result.success(user);
    }

    @Operation(summary="delUserById", description="DELETE_USER_BY_ID_NOTES")
    @Parameters(value={@Parameter(name="id", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_USER_BY_ID_ERROR)
    public Result delUserById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id) throws Exception {
        Map<String, Object> result = this.usersService.deleteUserById(loginUser, id);
        return this.returnDataList(result);
    }

    @Operation(summary="revokeProjectById", description="REVOKE_PROJECT_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="projectIds", description="PROJECT_IDS", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/revoke-project-by-id"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.REVOKE_PROJECT_ERROR)
    public Result revokeProjectById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="projectIds") String projectIds) {
        Map<String, Object> result = this.usersService.revokeProjectById(loginUser, userId, projectIds);
        return this.returnDataList(result);
    }

    @Operation(summary="grantProjectWithReadPerm", description="GRANT_PROJECT_WITH_READ_PERM_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="projectIds", description="PROJECT_IDS", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/grant-project-with-read-perm"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GRANT_PROJECT_ERROR)
    public Result grantProjectWithReadPerm(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="projectIds") String projectIds) {
        Map<String, Object> result = this.usersService.grantProjectWithReadPerm(loginUser, userId, projectIds);
        return this.returnDataList(result);
    }

    @Operation(summary="grantProject", description="GRANT_PROJECT_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="projectIds", description="PROJECT_IDS", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/grant-project"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GRANT_PROJECT_ERROR)
    public Result grantProject(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="projectIds") String projectIds) {
        Map<String, Object> result = this.usersService.grantProject(loginUser, userId, projectIds);
        return this.returnDataList(result);
    }

    @Operation(summary="grantProjectByCode", description="GRANT_PROJECT_BY_CODE_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class))})
    @PostMapping(value={"/grant-project-by-code"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GRANT_PROJECT_ERROR)
    public Result grantProjectByCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="projectCode") long projectCode) {
        Map<String, Object> result = this.usersService.grantProjectByCode(loginUser, userId, projectCode);
        return this.returnDataList(result);
    }

    @Operation(summary="revokeProject", description="REVOKE_PROJECT_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class, example="100"))})
    @PostMapping(value={"/revoke-project"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.REVOKE_PROJECT_ERROR)
    public Result revokeProject(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="projectCode") long projectCode) {
        Map<String, Object> result = this.usersService.revokeProject(loginUser, userId, projectCode);
        return this.returnDataList(result);
    }

    @Operation(summary="grantUDFFunc", description="GRANT_UDF_FUNC_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="udfIds", description="UDF_IDS", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/grant-udf-func"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GRANT_UDF_FUNCTION_ERROR)
    public Result grantUDFFunc(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="udfIds") String udfIds) {
        Map<String, Object> result = this.usersService.grantUDFFunction(loginUser, userId, udfIds);
        return this.returnDataList(result);
    }

    @Operation(summary="grantNamespace", description="GRANT_NAMESPACE_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="namespaceIds", description="NAMESPACE_IDS", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/grant-namespace"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GRANT_K8S_NAMESPACE_ERROR)
    public Result grantNamespace(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="namespaceIds") String namespaceIds) {
        Map<String, Object> result = this.usersService.grantNamespaces(loginUser, userId, namespaceIds);
        return this.returnDataList(result);
    }

    @Operation(summary="grantDataSource", description="GRANT_DATASOURCE_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="datasourceIds", description="DATASOURCE_IDS", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/grant-datasource"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GRANT_DATASOURCE_ERROR)
    public Result grantDataSource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="datasourceIds") String datasourceIds) {
        Map<String, Object> result = this.usersService.grantDataSource(loginUser, userId, datasourceIds);
        return this.returnDataList(result);
    }

    @Operation(summary="getUserInfo", description="GET_USER_INFO_NOTES")
    @GetMapping(value={"/get-user-info"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_USER_INFO_ERROR)
    public Result getUserInfo(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.usersService.getUserInfo(loginUser);
        return this.returnDataList(result);
    }

    @Operation(summary="listUser", description="LIST_USER_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.USER_LIST_ERROR)
    public Result listUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.usersService.queryAllGeneralUsers(loginUser);
        return this.returnDataList(result);
    }

    @GetMapping(value={"/list-all"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.USER_LIST_ERROR)
    public Result listAll(@RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.usersService.queryUserList(loginUser);
        return this.returnDataList(result);
    }

    @Operation(summary="verifyUserName", description="VERIFY_USER_NAME_NOTES")
    @Parameters(value={@Parameter(name="userName", description="USER_NAME", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/verify-user-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_USERNAME_ERROR)
    public Result verifyUserName(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userName") String userName) {
        return this.usersService.verifyUserName(userName);
    }

    @Operation(summary="unauthorizedUser", description="UNAUTHORIZED_USER_NOTES")
    @Parameters(value={@Parameter(name="alertgroupId", description="ALERT_GROUP_ID", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/unauth-user"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UNAUTHORIZED_USER_ERROR)
    public Result unauthorizedUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="alertgroupId") Integer alertgroupId) {
        Map<String, Object> result = this.usersService.unauthorizedUser(loginUser, alertgroupId);
        return this.returnDataList(result);
    }

    @Operation(summary="authorizedUser", description="AUTHORIZED_USER_NOTES")
    @Parameters(value={@Parameter(name="alertgroupId", description="ALERT_GROUP_ID", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/authed-user"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.AUTHORIZED_USER_ERROR)
    public Result authorizedUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="alertgroupId") Integer alertgroupId) {
        try {
            Map<String, Object> result = this.usersService.authorizedUser(loginUser, alertgroupId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            log.error(Status.AUTHORIZED_USER_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.AUTHORIZED_USER_ERROR.getCode(), Status.AUTHORIZED_USER_ERROR.getMsg());
        }
    }

    @Operation(summary="registerUser", description="REGISTER_USER_NOTES")
    @Parameters(value={@Parameter(name="userName", description="USER_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="userPassword", description="USER_PASSWORD", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="repeatPassword", description="REPEAT_PASSWORD", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="email", description="EMAIL", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/register"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.CREATE_USER_ERROR)
    public Result<Object> registerUser(@RequestParam(value="userName") String userName, @RequestParam(value="userPassword") String userPassword, @RequestParam(value="repeatPassword") String repeatPassword, @RequestParam(value="email") String email) throws Exception {
        userName = ParameterUtils.handleEscapes((String)userName);
        userPassword = ParameterUtils.handleEscapes((String)userPassword);
        repeatPassword = ParameterUtils.handleEscapes((String)repeatPassword);
        email = ParameterUtils.handleEscapes((String)email);
        Result<Object> verifyRet = this.usersService.verifyUserName(userName);
        if (verifyRet.getCode().intValue() != Status.SUCCESS.getCode()) {
            return verifyRet;
        }
        Map<String, Object> result = this.usersService.registerUser(userName, userPassword, repeatPassword, email);
        return this.returnDataList(result);
    }

    @Operation(summary="activateUser", description="ACTIVATE_USER_NOTES")
    @Parameters(value={@Parameter(name="userName", description="USER_NAME", schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/activate"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_USER_ERROR)
    public Result<Object> activateUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userName") String userName) {
        userName = ParameterUtils.handleEscapes((String)userName);
        Map<String, Object> result = this.usersService.activateUser(loginUser, userName);
        return this.returnDataList(result);
    }

    @Operation(summary="batchActivateUser", description="BATCH_ACTIVATE_USER_NOTES")
    @Parameters(value={@Parameter(name="userNames", description="USER_NAMES", required=true, schema=@Schema(implementation=List.class))})
    @PostMapping(value={"/batch/activate"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_USER_ERROR)
    public Result<Object> batchActivateUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody List<String> userNames) {
        List<String> formatUserNames = userNames.stream().map(ParameterUtils::handleEscapes).collect(Collectors.toList());
        Map<String, Object> result = this.usersService.batchActivateUser(loginUser, formatUserNames);
        return this.returnDataList(result);
    }
}

