/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProjectParameterService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="PROJECT_PARAMETER_TAG")
@RestController
@RequestMapping(value={"projects/{projectCode}/project-parameter"})
public class ProjectParameterController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectParameterController.class);
    @Autowired
    private ProjectParameterService projectParameterService;

    @Operation(summary="createProjectParameter", description="CREATE_PROJECT_PARAMETER_NOTES")
    @Parameters(value={@Parameter(name="projectParameterName", description="PROJECT_PARAMETER_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="projectParameterValue", description="PROJECT_PARAMETER_VALUE", schema=@Schema(implementation=String.class))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_PROJECT_PARAMETER_ERROR)
    public Result createProjectParameter(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="projectParameterName") String projectParameterName, @RequestParam(value="projectParameterValue") String projectParameterValue) {
        return this.projectParameterService.createProjectParameter(loginUser, projectCode, projectParameterName, projectParameterValue);
    }

    @Operation(summary="updateProjectParameter", description="UPDATE_PROJECT_PARAMETER_NOTES")
    @Parameters(value={@Parameter(name="code", description="PROJECT_PARAMETER_CODE", schema=@Schema(implementation=long.class, example="123456")), @Parameter(name="projectParameterName", description="PROJECT_PARAMETER_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="projectParameterValue", description="PROJECT_PARAMETER_VALUE", schema=@Schema(implementation=String.class))})
    @PutMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_PROJECT_PARAMETER_ERROR)
    public Result updateProjectParameter(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") Long code, @RequestParam(value="projectParameterName") String projectParameterName, @RequestParam(value="projectParameterValue") String projectParameterValue) {
        return this.projectParameterService.updateProjectParameter(loginUser, projectCode, code, projectParameterName, projectParameterValue);
    }

    @Operation(summary="deleteProjectParametersByCode", description="DELETE_PROJECT_PARAMETER_NOTES")
    @Parameters(value={@Parameter(name="code", description="PROJECT_PARAMETER_CODE", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_PROJECT_PARAMETER_ERROR)
    public Result deleteProjectParametersByCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="code") long code) {
        return this.projectParameterService.deleteProjectParametersByCode(loginUser, projectCode, code);
    }

    @Operation(summary="batchDeleteProjectParametersByCodes", description="DELETE_PROJECT_PARAMETER_NOTES")
    @Parameters(value={@Parameter(name="codes", description="PROJECT_PARAMETER_CODE", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/batch-delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_PROJECT_PARAMETER_ERROR)
    public Result batchDeleteProjectParametersByCodes(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="codes") String codes) {
        return this.projectParameterService.batchDeleteProjectParametersByCodes(loginUser, projectCode, codes);
    }

    @Operation(summary="queryProjectParameterListPaging", description="QUERY_PROJECT_PARAMETER_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", required=false, schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="10"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROJECT_PARAMETER_ERROR)
    public Result queryProjectParameterListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        this.checkPageParams(pageNo, pageSize);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.projectParameterService.queryProjectParameterListPaging(loginUser, projectCode, pageSize, pageNo, searchVal);
    }

    @Operation(summary="queryProjectParameterByCode", description="QUERY_PROJECT_PARAMETER_NOTES")
    @Parameters(value={@Parameter(name="code", description="PROJECT_PARAMETER_CODE", schema=@Schema(implementation=long.class, example="123456"))})
    @GetMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROJECT_PARAMETER_ERROR)
    public Result queryProjectParameterByCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code) {
        return this.projectParameterService.queryProjectParameterByCode(loginUser, projectCode, code);
    }
}

