/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.CommandStateCount;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.DataAnalysisService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.api.vo.TaskInstanceCountVO;
import org.apache.dolphinscheduler.api.vo.WorkflowDefinitionCountVO;
import org.apache.dolphinscheduler.api.vo.WorkflowInstanceCountVO;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="DATA_ANALYSIS_TAG")
@RestController
@RequestMapping(value={"projects/analysis"})
public class DataAnalysisController
extends BaseController {
    @Autowired
    private DataAnalysisService dataAnalysisService;

    @Operation(summary="countTaskState", description="COUNT_TASK_STATE_NOTES")
    @Parameters(value={@Parameter(name="startDate", description="START_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="endDate", description="END_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="projectCode", description="PROJECT_CODE", schema=@Schema(implementation=long.class, example="100"))})
    @GetMapping(value={"/task-state-count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.TASK_INSTANCE_STATE_COUNT_ERROR)
    public Result<TaskInstanceCountVO> getTaskInstanceStateCount(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate, @RequestParam(value="projectCode", required=false) Long projectCode) {
        if (projectCode == null) {
            return Result.success(this.dataAnalysisService.getAllTaskInstanceStateCount(loginUser, startDate, endDate));
        }
        return Result.success(this.dataAnalysisService.getTaskInstanceStateCountByProject(loginUser, projectCode, startDate, endDate));
    }

    @Operation(summary="countProcessInstanceState", description="COUNT_PROCESS_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="startDate", description="START_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="endDate", description="END_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="projectCode", description="PROJECT_CODE", schema=@Schema(implementation=long.class, example="100"))})
    @GetMapping(value={"/process-state-count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.COUNT_PROCESS_INSTANCE_STATE_ERROR)
    public Result<WorkflowInstanceCountVO> getWorkflowInstanceStateCount(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate, @RequestParam(value="projectCode", required=false) Long projectCode) {
        if (projectCode == null) {
            return Result.success(this.dataAnalysisService.getAllWorkflowInstanceStateCount(loginUser, startDate, endDate));
        }
        return Result.success(this.dataAnalysisService.getWorkflowInstanceStateCountByProject(loginUser, projectCode, startDate, endDate));
    }

    @Operation(summary="countDefinitionByUser", description="COUNT_PROCESS_DEFINITION_BY_USER_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", schema=@Schema(implementation=long.class, example="100"))})
    @GetMapping(value={"/define-user-count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.COUNT_PROCESS_DEFINITION_USER_ERROR)
    public Result<WorkflowDefinitionCountVO> countDefinitionByUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="projectCode", required=false) Long projectCode) {
        if (projectCode == null) {
            return Result.success(this.dataAnalysisService.getAllWorkflowDefinitionCount(loginUser));
        }
        return Result.success(this.dataAnalysisService.getWorkflowDefinitionCountByProject(loginUser, projectCode));
    }

    @Operation(summary="countCommandState", description="COUNT_COMMAND_STATE_NOTES")
    @GetMapping(value={"/command-state-count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.COMMAND_STATE_COUNT_ERROR)
    public Result<List<CommandStateCount>> countCommandState(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        List<CommandStateCount> commandStateCounts = this.dataAnalysisService.countCommandState(loginUser);
        return Result.success(commandStateCounts);
    }

    @Operation(summary="countQueueState", description="COUNT_QUEUE_STATE_NOTES")
    @GetMapping(value={"/queue-count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUEUE_COUNT_ERROR)
    public Result<Map<String, Integer>> countQueueState(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Integer> stringIntegerMap = this.dataAnalysisService.countQueueState(loginUser);
        return Result.success(stringIntegerMap);
    }
}

