/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.configuration;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.api.dto.FavTaskDto;
import org.apache.dolphinscheduler.common.config.YamlPropertySourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties
@PropertySource(value={"classpath:task-type-config.yaml"}, factory=YamlPropertySourceFactory.class)
@ConfigurationProperties(prefix="task")
public class TaskTypeConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskTypeConfiguration.class);
    private List<String> universal;
    private List<String> cloud;
    private List<String> logic;
    private List<String> dataIntegration;
    private List<String> dataQuality;
    private List<String> other;
    private List<String> machineLearning;
    private static final List<FavTaskDto> defaultTaskTypes = new ArrayList<FavTaskDto>();

    public List<FavTaskDto> getDefaultTaskTypes() {
        if (CollectionUtils.isNotEmpty(defaultTaskTypes)) {
            return defaultTaskTypes;
        }
        this.printDefaultTypes();
        this.universal.forEach(task -> defaultTaskTypes.add(new FavTaskDto((String)task, false, "Universal")));
        this.cloud.forEach(task -> defaultTaskTypes.add(new FavTaskDto((String)task, false, "Cloud")));
        this.logic.forEach(task -> defaultTaskTypes.add(new FavTaskDto((String)task, false, "Logic")));
        this.dataIntegration.forEach(task -> defaultTaskTypes.add(new FavTaskDto((String)task, false, "DataIntegration")));
        this.dataQuality.forEach(task -> defaultTaskTypes.add(new FavTaskDto((String)task, false, "DataQuality")));
        this.machineLearning.forEach(task -> defaultTaskTypes.add(new FavTaskDto((String)task, false, "MachineLearning")));
        this.other.forEach(task -> defaultTaskTypes.add(new FavTaskDto((String)task, false, "Other")));
        return defaultTaskTypes;
    }

    public void printDefaultTypes() {
        log.info("support default universal task types: {}", this.universal);
        log.info("support default cloud task types: {}", this.cloud);
        log.info("support default logic task types: {}", this.logic);
        log.info("support default dataIntegration task types: {}", this.dataIntegration);
        log.info("support default dataQuality task types: {}", this.dataQuality);
        log.info("support default machineLearning task types: {}", this.machineLearning);
        log.info("support default other task types: {}", this.other);
    }

    @Generated
    public List<String> getUniversal() {
        return this.universal;
    }

    @Generated
    public List<String> getCloud() {
        return this.cloud;
    }

    @Generated
    public List<String> getLogic() {
        return this.logic;
    }

    @Generated
    public List<String> getDataIntegration() {
        return this.dataIntegration;
    }

    @Generated
    public List<String> getDataQuality() {
        return this.dataQuality;
    }

    @Generated
    public List<String> getOther() {
        return this.other;
    }

    @Generated
    public List<String> getMachineLearning() {
        return this.machineLearning;
    }

    @Generated
    public void setUniversal(List<String> universal) {
        this.universal = universal;
    }

    @Generated
    public void setCloud(List<String> cloud) {
        this.cloud = cloud;
    }

    @Generated
    public void setLogic(List<String> logic) {
        this.logic = logic;
    }

    @Generated
    public void setDataIntegration(List<String> dataIntegration) {
        this.dataIntegration = dataIntegration;
    }

    @Generated
    public void setDataQuality(List<String> dataQuality) {
        this.dataQuality = dataQuality;
    }

    @Generated
    public void setOther(List<String> other) {
        this.other = other;
    }

    @Generated
    public void setMachineLearning(List<String> machineLearning) {
        this.machineLearning = machineLearning;
    }
}

