/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.api.dto.taskType.DynamicTaskInfo;
import org.apache.dolphinscheduler.common.config.YamlPropertySourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties
@PropertySource(value={"classpath:dynamic-task-type-config.yaml"}, factory=YamlPropertySourceFactory.class)
@ConfigurationProperties(prefix="dynamic-task")
public class DynamicTaskTypeConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicTaskTypeConfiguration.class);
    private static final List<String> defaultTaskCategories = Arrays.asList("Universal", "DataIntegration", "Cloud", "Logic", "DataQuality", "Other", "MachineLearning");
    private List<DynamicTaskInfo> universal;
    private List<DynamicTaskInfo> cloud;
    private List<DynamicTaskInfo> logic;
    private List<DynamicTaskInfo> dataIntegration;
    private List<DynamicTaskInfo> dataQuality;
    private List<DynamicTaskInfo> other;
    private List<DynamicTaskInfo> machineLearning;

    public List<String> getTaskCategories() {
        return defaultTaskCategories;
    }

    public List<DynamicTaskInfo> getTaskTypesByCategory(String category) {
        switch (category) {
            case "Universal": {
                return this.universal;
            }
            case "DataIntegration": {
                return this.cloud;
            }
            case "Cloud": {
                return this.logic;
            }
            case "Logic": {
                return this.dataIntegration;
            }
            case "DataQuality": {
                return this.dataQuality;
            }
            case "Other": {
                return this.other;
            }
            case "MachineLearning": {
                return this.machineLearning;
            }
        }
        return new ArrayList<DynamicTaskInfo>();
    }

    public void printDefaultTypes() {
        log.info("support default universal dynamic task types: {}", this.universal);
        log.info("support default cloud dynamic task types: {}", this.cloud);
        log.info("support default logic dynamic task types: {}", this.logic);
        log.info("support default dataIntegration dynamic task types: {}", this.dataIntegration);
        log.info("support default dataQuality dynamic task types: {}", this.dataQuality);
        log.info("support default machineLearning dynamic task types: {}", this.machineLearning);
        log.info("support default other dynamic task types: {}", this.other);
    }

    @Generated
    public List<DynamicTaskInfo> getUniversal() {
        return this.universal;
    }

    @Generated
    public List<DynamicTaskInfo> getCloud() {
        return this.cloud;
    }

    @Generated
    public List<DynamicTaskInfo> getLogic() {
        return this.logic;
    }

    @Generated
    public List<DynamicTaskInfo> getDataIntegration() {
        return this.dataIntegration;
    }

    @Generated
    public List<DynamicTaskInfo> getDataQuality() {
        return this.dataQuality;
    }

    @Generated
    public List<DynamicTaskInfo> getOther() {
        return this.other;
    }

    @Generated
    public List<DynamicTaskInfo> getMachineLearning() {
        return this.machineLearning;
    }

    @Generated
    public void setUniversal(List<DynamicTaskInfo> universal) {
        this.universal = universal;
    }

    @Generated
    public void setCloud(List<DynamicTaskInfo> cloud) {
        this.cloud = cloud;
    }

    @Generated
    public void setLogic(List<DynamicTaskInfo> logic) {
        this.logic = logic;
    }

    @Generated
    public void setDataIntegration(List<DynamicTaskInfo> dataIntegration) {
        this.dataIntegration = dataIntegration;
    }

    @Generated
    public void setDataQuality(List<DynamicTaskInfo> dataQuality) {
        this.dataQuality = dataQuality;
    }

    @Generated
    public void setOther(List<DynamicTaskInfo> other) {
        this.other = other;
    }

    @Generated
    public void setMachineLearning(List<DynamicTaskInfo> machineLearning) {
        this.machineLearning = machineLearning;
    }
}

