/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.api.metrics.ApiServerMetrics;
import org.apache.dolphinscheduler.common.enums.PluginType;
import org.apache.dolphinscheduler.common.thread.DefaultUncaughtExceptionHandler;
import org.apache.dolphinscheduler.dao.PluginDao;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.plugin.task.api.TaskChannelFactory;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.spi.params.PluginParamsTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.EventListener;

@ServletComponentScan
@SpringBootApplication
@ComponentScan(value={"org.apache.dolphinscheduler"})
public class ApiApplicationServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiApplicationServer.class);
    @Autowired
    private TaskPluginManager taskPluginManager;
    @Autowired
    private PluginDao pluginDao;

    public static void main(String[] args) {
        ApiServerMetrics.registerUncachedException(DefaultUncaughtExceptionHandler::getUncaughtExceptionCount);
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)DefaultUncaughtExceptionHandler.getInstance());
        SpringApplication.run(ApiApplicationServer.class, (String[])new String[0]);
    }

    @EventListener
    public void run(ApplicationReadyEvent readyEvent) {
        log.info("Received spring application context ready event will load taskPlugin and write to DB");
        this.taskPluginManager.loadPlugin();
        for (Map.Entry entry : this.taskPluginManager.getTaskChannelFactoryMap().entrySet()) {
            String taskPluginName = (String)entry.getKey();
            TaskChannelFactory taskChannelFactory = (TaskChannelFactory)entry.getValue();
            List params = taskChannelFactory.getParams();
            String paramsJson = PluginParamsTransfer.transferParamsToJson((List)params);
            PluginDefine pluginDefine = new PluginDefine(taskPluginName, PluginType.TASK.getDesc(), paramsJson);
            this.pluginDao.addOrUpdatePluginDefine(pluginDefine);
        }
    }
}

