/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.api.junit;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.cdise.api.CdiContainer;
import org.apache.deltaspike.cdise.api.CdiContainerLoader;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.config.PropertyLoader;
import org.apache.deltaspike.testcontrol.api.junit.TestBaseConfig;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class CdiTestSuiteRunner
extends Suite {
    public static final String CUSTOM_TEST_CONTAINER_CONFIG_FILE_KEY = "deltaspike.testcontrol.test-container.config-file";
    public static final String DEFAULT_TEST_CONTAINER_CONFIG_FILE_NAME = "META-INF/apache-deltaspike_test-container";
    private static final boolean STOP_CONTAINER = TestBaseConfig.ContainerIntegration.STOP_CONTAINER;
    private static volatile boolean containerStarted;
    private final Class<?> testSuiteClass;

    public CdiTestSuiteRunner(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        super(klass, builder);
        this.testSuiteClass = klass;
    }

    protected CdiTestSuiteRunner(Class<?> klass, Class<?>[] suiteClasses) throws InitializationError {
        super(klass, (Class[])suiteClasses);
        this.testSuiteClass = klass;
    }

    protected CdiTestSuiteRunner(RunnerBuilder builder, Class<?> klass, Class<?>[] suiteClasses) throws InitializationError {
        super(builder, klass, (Class[])suiteClasses);
        this.testSuiteClass = klass;
    }

    protected CdiTestSuiteRunner(Class<?> klass, List<Runner> runners) throws InitializationError {
        super(klass, runners);
        this.testSuiteClass = klass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        if (this.testSuiteClass == null) {
            throw new IllegalStateException("no test-suite class found");
        }
        CdiContainer container = CdiContainerLoader.getCdiContainer();
        if (!containerStarted) {
            container.boot((Map)CdiTestSuiteRunner.getTestContainerConfig());
            containerStarted = true;
        }
        notifier.addListener((RunListener)new LogRunListener());
        try {
            super.run(notifier);
        }
        finally {
            if (STOP_CONTAINER) {
                container.shutdown();
                containerStarted = false;
            }
        }
    }

    public static boolean isContainerStarted() {
        return containerStarted;
    }

    static Boolean isStopContainerAllowed() {
        return STOP_CONTAINER;
    }

    static void setContainerStarted(boolean containerStarted) {
        CdiTestSuiteRunner.containerStarted = containerStarted;
    }

    public static Properties getTestContainerConfig() {
        String cdiTestRunnerConfig = ConfigResolver.getProjectStageAwarePropertyValue((String)CUSTOM_TEST_CONTAINER_CONFIG_FILE_KEY, (String)DEFAULT_TEST_CONTAINER_CONFIG_FILE_NAME);
        return PropertyLoader.getProperties((String)cdiTestRunnerConfig);
    }

    static class LogRunListener
    extends RunListener {
        private final Logger logger = Logger.getLogger(LogRunListener.class.getName());

        LogRunListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testStarted(Description description) throws Exception {
            Level level = this.logger.getLevel();
            this.logger.setLevel(Level.INFO);
            this.logger.info("[run] " + description.getClassName() + "#" + description.getMethodName());
            try {
                super.testRunStarted(description);
            }
            finally {
                this.logger.setLevel(level);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testFinished(Description description) throws Exception {
            Level level = this.logger.getLevel();
            this.logger.setLevel(Level.INFO);
            this.logger.info("[finished] " + description.getClassName() + "#" + description.getMethodName());
            try {
                super.testFinished(description);
            }
            finally {
                this.logger.setLevel(level);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testFailure(Failure failure) throws Exception {
            Level level = this.logger.getLevel();
            this.logger.setLevel(Level.INFO);
            Description description = failure.getDescription();
            this.logger.info("[failed] " + description.getClassName() + "#" + description.getMethodName() + " message: " + failure.getMessage());
            try {
                super.testFailure(failure);
            }
            finally {
                this.logger.setLevel(level);
            }
        }
    }
}

