/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.partialbean.impl;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ReflectionUtils;
import org.apache.deltaspike.core.util.metadata.builder.ContextualLifecycle;

public class DeltaSpikePartialProducerLifecycle<T>
implements ContextualLifecycle<T> {
    private final Class targetPartialBeanClass;
    private final Method producerMethod;

    public DeltaSpikePartialProducerLifecycle(Class targetPartialBeanClass, Method producerMethod) {
        this.targetPartialBeanClass = targetPartialBeanClass;
        this.producerMethod = producerMethod;
    }

    @Override
    public T create(Bean<T> bean, CreationalContext<T> creationalContext) {
        Object partialBean = BeanProvider.getContextualReference(this.targetPartialBeanClass, new Annotation[0]);
        return (T)ReflectionUtils.invokeMethod(partialBean, this.producerMethod, Object.class, false, new Object[0]);
    }

    @Override
    public void destroy(Bean<T> bean, T instance, CreationalContext<T> creationalContext) {
    }
}

