/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util.metadata.builder;

import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedConstructorImpl;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedFieldImpl;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedImpl;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedMethodImpl;
import org.apache.deltaspike.core.util.metadata.builder.AnnotationStore;

class AnnotatedTypeImpl<X>
extends AnnotatedImpl
implements AnnotatedType<X> {
    private final Set<AnnotatedConstructor<X>> constructors;
    private final Set<AnnotatedField<? super X>> fields;
    private final Set<AnnotatedMethod<? super X>> methods;
    private final Class<X> javaClass;

    AnnotatedTypeImpl(Class<X> clazz, AnnotationStore typeAnnotations, Map<Field, AnnotationStore> fieldAnnotations, Map<Method, AnnotationStore> methodAnnotations, Map<Method, Map<Integer, AnnotationStore>> methodParameterAnnotations, Map<Constructor<?>, AnnotationStore> constructorAnnotations, Map<Constructor<?>, Map<Integer, AnnotationStore>> constructorParameterAnnotations, Map<Field, Type> fieldTypes, Map<Method, Map<Integer, Type>> methodParameterTypes, Map<Constructor<?>, Map<Integer, Type>> constructorParameterTypes) {
        super(clazz, typeAnnotations, null, null);
        this.javaClass = clazz;
        this.constructors = new HashSet<AnnotatedConstructor<X>>();
        HashSet cset = new HashSet();
        HashSet<Object> mset = new HashSet<Object>();
        HashSet<Object> fset = new HashSet<Object>();
        for (Constructor<?> c : clazz.getConstructors()) {
            AnnotatedConstructorImpl nc = new AnnotatedConstructorImpl(this, c, constructorAnnotations.get(c), constructorParameterAnnotations.get(c), constructorParameterTypes.get(c));
            this.constructors.add(nc);
            cset.add(c);
        }
        for (Map.Entry entry : constructorAnnotations.entrySet()) {
            if (cset.contains(entry.getKey())) continue;
            AnnotatedConstructorImpl nc = new AnnotatedConstructorImpl(this, (Constructor)entry.getKey(), (AnnotationStore)entry.getValue(), constructorParameterAnnotations.get(entry.getKey()), constructorParameterTypes.get(entry.getKey()));
            this.constructors.add(nc);
        }
        this.methods = new HashSet<AnnotatedMethod<? super X>>();
        for (Method m : clazz.getMethods()) {
            if (m.getDeclaringClass().equals(Object.class) || m.getDeclaringClass().equals(Annotation.class)) continue;
            AnnotatedMethodImpl met = new AnnotatedMethodImpl(this, m, methodAnnotations.get(m), methodParameterAnnotations.get(m), methodParameterTypes.get(m));
            this.methods.add(met);
            mset.add(m);
        }
        for (Map.Entry entry : methodAnnotations.entrySet()) {
            if (((Method)entry.getKey()).getDeclaringClass().equals(Object.class) || mset.contains(entry.getKey())) continue;
            AnnotatedMethodImpl nc = new AnnotatedMethodImpl(this, (Method)entry.getKey(), (AnnotationStore)entry.getValue(), methodParameterAnnotations.get(entry.getKey()), methodParameterTypes.get(entry.getKey()));
            this.methods.add(nc);
        }
        this.fields = new HashSet<AnnotatedField<? super X>>();
        for (Field f : clazz.getFields()) {
            AnnotatedFieldImpl b = new AnnotatedFieldImpl(this, f, fieldAnnotations.get(f), fieldTypes.get(f));
            this.fields.add(b);
            fset.add(f);
        }
        for (Map.Entry entry : fieldAnnotations.entrySet()) {
            if (fset.contains(entry.getKey())) continue;
            this.fields.add(new AnnotatedFieldImpl(this, (Field)entry.getKey(), (AnnotationStore)entry.getValue(), fieldTypes.get(entry.getKey())));
        }
    }

    public Set<AnnotatedConstructor<X>> getConstructors() {
        return Collections.unmodifiableSet(this.constructors);
    }

    public Set<AnnotatedField<? super X>> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Class<X> getJavaClass() {
        return this.javaClass;
    }

    public Set<AnnotatedMethod<? super X>> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }
}

