/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import jakarta.enterprise.inject.Typed;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

@Typed
public abstract class ClassUtils {
    private ClassUtils() {
    }

    public static ClassLoader getClassLoader(Object o) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetClassLoaderAction(o));
        }
        return ClassUtils.getClassLoaderInternal(o);
    }

    private static ClassLoader getClassLoaderInternal(Object o) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null && o != null) {
            loader = o.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = ClassUtils.class.getClassLoader();
        }
        return loader;
    }

    public static boolean isProxyableClass(Type type) {
        Class clazz = null;
        if (type instanceof Class) {
            clazz = (Class)type;
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        }
        if (clazz == null) {
            return false;
        }
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            if (Modifier.isPrivate(constructor.getModifiers())) {
                return false;
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        if (Modifier.isFinal(clazz.getModifiers())) {
            return false;
        }
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() == Object.class || method.isBridge() || method.isSynthetic() || Modifier.isStatic(method.getModifiers()) || Modifier.isPrivate(method.getModifiers()) || !Modifier.isFinal(method.getModifiers())) continue;
            return false;
        }
        return !clazz.isPrimitive() && !clazz.isArray();
    }

    public static <T> Class<T> tryToLoadClassForName(String name, Class<T> targetType) {
        return ClassUtils.tryToLoadClassForName(name);
    }

    public static <T> Class<T> tryToLoadClassForName(String name, Class<T> targetType, ClassLoader classLoader) {
        return ClassUtils.tryToLoadClassForName(name, classLoader);
    }

    public static Class tryToLoadClassForName(String name) {
        try {
            return ClassUtils.loadClassForName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class tryToLoadClassForName(String name, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class loadClassForName(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name, false, ClassUtils.getClassLoader(null));
        }
        catch (ClassNotFoundException ignore) {
            return Class.forName(name, false, ClassUtils.class.getClassLoader());
        }
    }

    public static <T> T tryToInstantiateClass(Class<T> targetClass) {
        try {
            return targetClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public static <T> T tryToInstantiateClassForName(String className, Class<T> targetType) {
        Object result = ClassUtils.tryToInstantiateClassForName(className);
        return (T)(result != null ? result : null);
    }

    public static Object tryToInstantiateClassForName(String className) {
        try {
            return ClassUtils.instantiateClassForName(className);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object instantiateClassForName(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return ClassUtils.loadClassForName(className).newInstance();
    }

    public static String getJarVersion(Class targetClass) {
        String manifestFileLocation = ClassUtils.getManifestFileLocationOfClass(targetClass);
        try {
            return new Manifest(new URL(manifestFileLocation).openStream()).getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getRevision(Class targetClass) {
        String manifestFileLocation = ClassUtils.getManifestFileLocationOfClass(targetClass);
        try {
            return new Manifest(new URL(manifestFileLocation).openStream()).getMainAttributes().getValue("Revision");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getManifestFileLocationOfClass(Class targetClass) {
        String manifestFileLocation;
        try {
            manifestFileLocation = ClassUtils.getManifestLocation(targetClass);
        }
        catch (Exception e) {
            manifestFileLocation = ClassUtils.getManifestLocation(targetClass.getSuperclass());
        }
        return manifestFileLocation;
    }

    private static String getManifestLocation(Class targetClass) {
        String classFilePath = targetClass.getCanonicalName().replace('.', '/') + ".class";
        String manifestFilePath = "/META-INF/MANIFEST.MF";
        String classLocation = targetClass.getResource(targetClass.getSimpleName() + ".class").toString();
        return classLocation.substring(0, classLocation.indexOf(classFilePath) - 1) + manifestFilePath;
    }

    public static boolean containsMethod(Class<?> targetClass, Method method) {
        return ClassUtils.extractMethod(targetClass, method) != null;
    }

    public static Method extractMethod(Class<?> clazz, Method sourceMethod) {
        try {
            String name = sourceMethod.getName();
            return clazz != null ? clazz.getMethod(name, sourceMethod.getParameterTypes()) : null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean containsPossiblyGenericMethod(Class<?> targetClass, Method method) {
        return ClassUtils.extractPossiblyGenericMethod(targetClass, method) != null;
    }

    public static Method extractPossiblyGenericMethod(Class<?> clazz, Method sourceMethod) {
        Method exactMethod = ClassUtils.extractMethod(clazz, sourceMethod);
        if (exactMethod == null) {
            String methodName = sourceMethod.getName();
            Class<?>[] parameterTypes = sourceMethod.getParameterTypes();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(methodName) || !ClassUtils.allSameType(method.getParameterTypes(), parameterTypes)) continue;
                return method;
            }
            return null;
        }
        return exactMethod;
    }

    private static boolean allSameType(Class<?>[] left, Class<?>[] right) {
        if (left.length != right.length) {
            return false;
        }
        for (int p = 0; p < left.length; ++p) {
            if (left[p].isAssignableFrom(right[p])) continue;
            return false;
        }
        return true;
    }

    public static boolean returns(Method method, Class<?> clazz) {
        return method.getReturnType().isAssignableFrom(clazz);
    }

    static class GetClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        private Object object;

        GetClassLoaderAction(Object object) {
            this.object = object;
        }

        @Override
        public ClassLoader run() {
            try {
                return ClassUtils.getClassLoaderInternal(this.object);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

