/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.util;

import jakarta.enterprise.inject.Typed;
import jakarta.naming.InitialContext;
import jakarta.naming.Name;
import jakarta.naming.NameClassPair;
import jakarta.naming.NameParser;
import jakarta.naming.NamingEnumeration;
import jakarta.naming.NamingException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;

@Typed
public abstract class JndiUtils {
    private static final Logger LOG = Logger.getLogger(JndiUtils.class.getName());
    private static InitialContext initialContext = null;

    private JndiUtils() {
    }

    public static <T> T lookup(Name name, Class<? extends T> targetType) {
        try {
            return JndiUtils.verifyLookupResult(initialContext.lookup(name), name.toString(), targetType);
        }
        catch (NamingException e) {
            throw ExceptionUtils.throwAsRuntimeException(e);
        }
    }

    public static <T> T lookup(String name, Class<? extends T> targetType) {
        try {
            return JndiUtils.verifyLookupResult(initialContext.lookup(name), name, targetType);
        }
        catch (NamingException e) {
            throw ExceptionUtils.throwAsRuntimeException(e);
        }
    }

    private static <T> T verifyLookupResult(Object result, String name, Class<? extends T> targetType) {
        block9: {
            if (result != null) {
                if (targetType.isAssignableFrom(result.getClass())) {
                    return (T)result;
                }
                if (result instanceof String) {
                    try {
                        Class classOfResult = ClassUtils.loadClassForName((String)result);
                        if (targetType.isAssignableFrom(classOfResult)) {
                            try {
                                return classOfResult.newInstance();
                            }
                            catch (Exception e) {
                                LOG.log(Level.SEVERE, "Class " + classOfResult + " from JNDI lookup for name " + name + " could not be instantiated", e);
                                break block9;
                            }
                        }
                        LOG.log(Level.SEVERE, "JNDI lookup for key " + name + " returned class " + classOfResult.getName() + " which does not implement/extend the expected class" + targetType.getName());
                    }
                    catch (ClassNotFoundException cnfe) {
                        LOG.log(Level.SEVERE, "Could not find Class " + result + " from JNDI lookup for name " + name, cnfe);
                    }
                } else {
                    LOG.log(Level.SEVERE, "JNDI lookup for key " + name + " should return a value of " + targetType + ", but returned " + result);
                }
            }
        }
        return null;
    }

    public static <T> Map<String, T> list(String name, Class<T> type) {
        HashMap<String, T> result = new HashMap<String, T>();
        try {
            NameParser nameParser = initialContext.getNameParser(name);
            NamingEnumeration enumeration = initialContext.list(name);
            while (enumeration.hasMoreElements()) {
                try {
                    NameClassPair binding = (NameClassPair)enumeration.nextElement();
                    Name bindingName = nameParser.parse(name).add(binding.getName());
                    result.put(binding.getName(), JndiUtils.lookup(bindingName, type));
                }
                catch (NamingException e) {
                    if (!LOG.isLoggable(Level.FINEST)) continue;
                    LOG.log(Level.FINEST, "InitialContext#list failed!", e);
                }
            }
        }
        catch (NamingException e) {
            LOG.log(Level.WARNING, "Problem reading the name of the JNDI location " + name + " or failuring listing pairs.", e);
        }
        return result;
    }

    static {
        try {
            initialContext = new InitialContext();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

