/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.monitoring;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.monitoring.InvocationMonitored;
import org.apache.deltaspike.core.impl.monitoring.RequestInvocationCounter;

@Interceptor
@InvocationMonitored
public class InvocationMonitorInterceptor
implements Serializable {
    private static final Logger logger = Logger.getLogger(InvocationMonitorInterceptor.class.getName());
    @Inject
    private RequestInvocationCounter requestInvocationCounter;

    @AroundInvoke
    public Object track(InvocationContext ic) throws Exception {
        long start = System.nanoTime();
        Object retVal = ic.proceed();
        long end = System.nanoTime();
        try {
            this.requestInvocationCounter.count(ic.getTarget().getClass().getName(), ic.getMethod().getName(), end - start);
        }
        catch (ContextNotActiveException cnae) {
            logger.log(Level.FINE, "could not monitor invocatino to {} due to RequestContext not being active", ic.getMethod().toString());
        }
        return retVal;
    }
}

