/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.deltaspike.core.api.literal.AnyLiteral;
import org.apache.deltaspike.core.api.message.LocaleResolver;
import org.apache.deltaspike.core.api.message.Message;
import org.apache.deltaspike.core.api.message.MessageContext;
import org.apache.deltaspike.core.api.message.MessageContextConfig;
import org.apache.deltaspike.core.api.message.MessageInterpolator;
import org.apache.deltaspike.core.api.message.MessageResolver;
import org.apache.deltaspike.core.api.message.MessageTemplate;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ClassUtils;

@Dependent
@Typed(value={MessageBundleInvocationHandler.class})
public class MessageBundleInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -8980912335543392357L;
    @Inject
    private MessageContext baseMessageContext = null;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(Object.class)) {
            if ("hashCode".equals(method.getName())) {
                return proxy.getClass().hashCode();
            }
            if ("toString".equals(method.getName())) {
                return proxy.getClass().toString();
            }
            if ("equals".equals(method.getName())) {
                return proxy.getClass().equals(args[0].getClass());
            }
            return null;
        }
        MessageTemplate messageTemplate = method.getAnnotation(MessageTemplate.class);
        String messageTemplateValue = messageTemplate != null ? messageTemplate.value() : "{" + method.getName() + "}";
        MessageContext messageContext = this.resolveMessageContextFromArguments(args);
        List<Serializable> arguments = this.resolveMessageArguments(args);
        if (messageContext == null) {
            messageContext = this.baseMessageContext.clone();
            MessageContextConfig messageContextConfig = method.getDeclaringClass().getAnnotation(MessageContextConfig.class);
            if (messageContextConfig != null) {
                this.applyMessageContextConfig(messageContext, messageContextConfig);
            }
        }
        String messageBundleName = method.getDeclaringClass().getName();
        Message message = messageContext.messageSource(messageBundleName).message().template(messageTemplateValue).argument(arguments.toArray(new Serializable[arguments.size()]));
        if (String.class.isAssignableFrom(method.getReturnType())) {
            return message.toString();
        }
        return message;
    }

    private void applyMessageContextConfig(MessageContext messageContext, MessageContextConfig messageContextConfig) {
        if (!MessageResolver.class.equals(messageContextConfig.messageResolver())) {
            Class messageResolverClass = ClassUtils.tryToLoadClassForName(messageContextConfig.messageResolver().getName());
            messageContext.messageResolver((MessageResolver)BeanProvider.getContextualReference(messageResolverClass, new Annotation[]{new AnyLiteral()}));
        }
        if (!MessageInterpolator.class.equals(messageContextConfig.messageInterpolator())) {
            Class messageInterpolatorClass = ClassUtils.tryToLoadClassForName(messageContextConfig.messageInterpolator().getName());
            messageContext.messageInterpolator((MessageInterpolator)BeanProvider.getContextualReference(messageInterpolatorClass, new Annotation[]{new AnyLiteral()}));
        }
        if (!LocaleResolver.class.equals(messageContextConfig.localeResolver())) {
            Class localeResolverClass = ClassUtils.tryToLoadClassForName(messageContextConfig.localeResolver().getName());
            messageContext.localeResolver((LocaleResolver)BeanProvider.getContextualReference(localeResolverClass, new Annotation[]{new AnyLiteral()}));
        }
        String[] messageSources = messageContextConfig.messageSource();
        messageContext.messageSource(messageSources);
    }

    private List<Serializable> resolveMessageArguments(Object[] args) {
        ArrayList<Serializable> arguments = new ArrayList<Serializable>();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (i == 0 && arg != null && MessageContext.class.isAssignableFrom(arg.getClass())) continue;
                if (arg instanceof Serializable) {
                    arguments.add((Serializable)arg);
                    continue;
                }
                arguments.add((Serializable)((Object)(arg == null ? null : arg.toString())));
            }
        }
        return arguments;
    }

    private MessageContext resolveMessageContextFromArguments(Object[] args) {
        if (args != null && args.length > 0 && args[0] != null && MessageContext.class.isAssignableFrom(args[0].getClass())) {
            return (MessageContext)args[0];
        }
        return null;
    }
}

