/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.interceptor.interdyn;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.interceptor.InterceptorBinding;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.config.base.CoreBaseConfig;
import org.apache.deltaspike.core.impl.interceptor.interdyn.AnnotationRule;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.metadata.AnnotationInstanceProvider;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;

public class InterDynExtension
implements Deactivatable,
Extension {
    private List<AnnotationRule> interceptorRules = new ArrayList<AnnotationRule>();
    private Logger logger = Logger.getLogger(InterDynExtension.class.getName());
    private Map<String, Annotation> usedInterceptorBindings = new HashMap<String, Annotation>();
    private boolean enabled = false;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        if (!ClassDeactivationUtils.isActivated(this.getClass())) {
            return;
        }
        this.enabled = CoreBaseConfig.InterDynCustomization.INTERDYN_ENABLED.getValue();
        if (this.enabled) {
            this.logger.info("Starting with deltaspike.interdyn instrumentation");
            this.init();
        }
    }

    public void init() {
        HashSet<String> ruleConfigKeys = new HashSet<String>();
        for (String propertyName : ConfigResolver.getAllProperties().keySet()) {
            if (!propertyName.startsWith("deltaspike.interdyn.rule.") || !propertyName.contains(".match")) continue;
            ruleConfigKeys.add(propertyName.substring(0, propertyName.indexOf(".match")));
        }
        for (String ruleConfigKey : ruleConfigKeys) {
            String match = ConfigResolver.getPropertyValue(ruleConfigKey + ".match");
            String annotationClassName = ConfigResolver.getPropertyValue(ruleConfigKey + ".annotation");
            if (match == null || annotationClassName == null || match.length() <= 0 || annotationClassName.length() <= 0) continue;
            Annotation anno = this.getAnnotationImplementation(annotationClassName);
            boolean requiresProxy = anno.annotationType().getAnnotation(InterceptorBinding.class) != null;
            this.interceptorRules.add(new AnnotationRule(match, anno, requiresProxy));
        }
        if (this.interceptorRules.isEmpty()) {
            this.enabled = false;
        }
    }

    public void processAnnotatedType(@Observes ProcessAnnotatedType pat) {
        if (this.enabled) {
            AnnotatedType at = pat.getAnnotatedType();
            String beanClassName = at.getJavaClass().getName();
            AnnotatedTypeBuilder atb = null;
            for (AnnotationRule rule : this.interceptorRules) {
                if (!beanClassName.matches(rule.getRule())) continue;
                if (rule.requiresProxy() && !ClassUtils.isProxyableClass(at.getJavaClass())) {
                    this.logger.info("Skipping unproxyable class " + beanClassName + " even if matches rule=" + rule.getRule());
                    return;
                }
                if (atb == null) {
                    atb = new AnnotatedTypeBuilder();
                    atb.readFromType(at);
                }
                atb.addToClass(rule.getAdditionalAnnotation());
                this.logger.info("Adding Dynamic Interceptor " + rule.getAdditionalAnnotation() + " to class " + beanClassName);
            }
            if (atb != null) {
                pat.setAnnotatedType(atb.create());
            }
        }
    }

    private Annotation getAnnotationImplementation(String interceptorBindingClassName) {
        Annotation ann = this.usedInterceptorBindings.get(interceptorBindingClassName);
        if (ann == null) {
            Class<?> annClass;
            try {
                annClass = ClassUtils.getClassLoader(null).loadClass(interceptorBindingClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Error while picking up dynamic InterceptorBindingType for class" + interceptorBindingClassName, e);
            }
            ann = AnnotationInstanceProvider.of(annClass);
            this.usedInterceptorBindings.put(interceptorBindingClassName, ann);
        }
        return ann;
    }
}

