/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.exception.control.extension;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.InjectionException;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.enterprise.inject.spi.ProcessBean;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.exception.control.ExceptionHandler;
import org.apache.deltaspike.core.api.exception.control.HandlerMethod;
import org.apache.deltaspike.core.impl.exception.control.HandlerMethodImpl;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;

public class ExceptionControlExtension
implements Extension,
Deactivatable {
    private static final Logger LOG = Logger.getLogger(ExceptionControlExtension.class.getName());
    private Map<Type, Collection<HandlerMethod<? extends Throwable>>> allHandlers = new HashMap<Type, Collection<HandlerMethod<? extends Throwable>>>();
    private Boolean isActivated = true;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    public <T> void findHandlers(@Observes ProcessBean<?> processBean, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        if (processBean.getBean() instanceof Interceptor || processBean.getBean() instanceof Decorator || !(processBean.getAnnotated() instanceof AnnotatedType)) {
            return;
        }
        AnnotatedType annotatedType = (AnnotatedType)processBean.getAnnotated();
        if (annotatedType.getJavaClass().isAnnotationPresent(ExceptionHandler.class)) {
            Set methods = annotatedType.getMethods();
            for (AnnotatedMethod method : methods) {
                if (!HandlerMethodImpl.isHandler(method)) continue;
                if (method.getJavaMember().getExceptionTypes().length != 0) {
                    processBean.addDefinitionError((Throwable)new IllegalArgumentException(String.format("Handler method %s must not throw exceptions", method.getJavaMember())));
                }
                this.registerHandlerMethod(new HandlerMethodImpl(processBean.getBean(), method, beanManager));
            }
        }
    }

    public void verifyInjectionPoints(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager bm) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        for (Map.Entry<Type, Collection<HandlerMethod<? extends Throwable>>> entry : this.allHandlers.entrySet()) {
            for (HandlerMethod<? extends Throwable> handler : entry.getValue()) {
                for (InjectionPoint ip : ((HandlerMethodImpl)handler).getInjectionPoints(bm)) {
                    try {
                        bm.validate(ip);
                    }
                    catch (InjectionException e) {
                        afterDeploymentValidation.addDeploymentProblem((Throwable)e);
                    }
                }
            }
        }
    }

    public Map<Type, Collection<HandlerMethod<? extends Throwable>>> getAllExceptionHandlers() {
        return Collections.unmodifiableMap(this.allHandlers);
    }

    private <T extends Throwable> void registerHandlerMethod(HandlerMethod<T> handlerMethod) {
        LOG.fine(String.format("Adding handler %s to known handlers", handlerMethod));
        if (this.allHandlers.containsKey(handlerMethod.getExceptionType())) {
            this.allHandlers.get(handlerMethod.getExceptionType()).add(handlerMethod);
        } else {
            this.allHandlers.put(handlerMethod.getExceptionType(), new HashSet<HandlerMethod>(Arrays.asList(handlerMethod)));
        }
    }
}

