/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.exception.control;

import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.exception.control.HandlerMethod;
import org.apache.deltaspike.core.api.literal.AnyLiteral;
import org.apache.deltaspike.core.impl.exception.control.ExceptionHandlerComparator;
import org.apache.deltaspike.core.impl.exception.control.HandlerMethodStorage;
import org.apache.deltaspike.core.util.HierarchyDiscovery;

@Typed
class HandlerMethodStorageImpl
implements HandlerMethodStorage {
    private final Map<Type, Collection<HandlerMethod<? extends Throwable>>> allHandlers;
    private Logger log = Logger.getLogger(HandlerMethodStorageImpl.class.getName());

    HandlerMethodStorageImpl(Map<Type, Collection<HandlerMethod<? extends Throwable>>> allHandlers) {
        this.allHandlers = allHandlers;
    }

    @Override
    public <T extends Throwable> void registerHandlerMethod(HandlerMethod<T> handlerMethod) {
        this.log.fine(String.format("Adding handler %s to known handlers", handlerMethod));
        if (this.allHandlers.containsKey(handlerMethod.getExceptionType())) {
            this.allHandlers.get(handlerMethod.getExceptionType()).add(handlerMethod);
        } else {
            this.allHandlers.put(handlerMethod.getExceptionType(), new HashSet<HandlerMethod<T>>(Collections.singleton(handlerMethod)));
        }
    }

    @Override
    public Collection<HandlerMethod<? extends Throwable>> getHandlersForException(Type exceptionClass, BeanManager bm, Set<Annotation> handlerQualifiers, boolean isBefore) {
        TreeSet<HandlerMethod<? extends Throwable>> returningHandlers = new TreeSet<HandlerMethod<? extends Throwable>>(new ExceptionHandlerComparator());
        HierarchyDiscovery h = new HierarchyDiscovery(exceptionClass);
        Set<Type> closure = h.getTypeClosure();
        for (Type hierarchyType : closure) {
            if (this.allHandlers.get(hierarchyType) == null) continue;
            for (HandlerMethod<? extends Throwable> handler : this.allHandlers.get(hierarchyType)) {
                if (handler.isBeforeHandler() && isBefore) {
                    if (handler.getQualifiers().contains((Object)new AnyLiteral())) {
                        returningHandlers.add(handler);
                        continue;
                    }
                    if (handlerQualifiers.isEmpty() || !handlerQualifiers.equals(handler.getQualifiers())) continue;
                    returningHandlers.add(handler);
                    continue;
                }
                if (handler.isBeforeHandler() || isBefore) continue;
                if (handler.getQualifiers().contains((Object)new AnyLiteral())) {
                    returningHandlers.add(handler);
                    continue;
                }
                if (handlerQualifiers.isEmpty() || !handlerQualifiers.equals(handler.getQualifiers())) continue;
                returningHandlers.add(handler);
            }
        }
        this.log.fine(String.format("Found handlers %s for exception type %s, qualifiers %s", returningHandlers, exceptionClass, handlerQualifiers));
        return Collections.unmodifiableCollection(returningHandlers);
    }
}

