/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.exception.control;

import jakarta.enterprise.inject.Typed;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.apache.deltaspike.core.api.exception.control.HandlerMethod;
import org.apache.deltaspike.core.api.literal.AnyLiteral;
import org.apache.deltaspike.core.util.HierarchyDiscovery;

@Typed
public final class ExceptionHandlerComparator
implements Comparator<HandlerMethod<?>> {
    @Override
    public int compare(HandlerMethod<?> lhs, HandlerMethod<?> rhs) {
        if (lhs.equals(rhs)) {
            return 0;
        }
        if (lhs.getExceptionType().equals(rhs.getExceptionType()) && lhs.getQualifiers().equals(rhs.getQualifiers())) {
            int precedenceReturnValue = this.comparePrecedence(lhs.getOrdinal(), rhs.getOrdinal(), lhs.isBeforeHandler());
            if (precedenceReturnValue == 0) {
                return -1;
            }
            return precedenceReturnValue;
        }
        if (lhs.getExceptionType().equals(rhs.getExceptionType()) && !lhs.getQualifiers().equals(rhs.getQualifiers())) {
            if (lhs.getQualifiers().contains((Object)new AnyLiteral())) {
                return -1;
            }
            return 1;
        }
        return this.compareHierarchies(lhs.getExceptionType(), rhs.getExceptionType());
    }

    private int compareHierarchies(Type lhsExceptionType, Type rhsExceptionType) {
        int indexOfRhsType;
        int indexOfLhsType;
        HierarchyDiscovery lhsHierarchy = new HierarchyDiscovery(lhsExceptionType);
        Set<Type> lhsTypeclosure = lhsHierarchy.getTypeClosure();
        if (lhsTypeclosure.contains(rhsExceptionType) && (indexOfLhsType = new ArrayList<Type>(lhsTypeclosure).indexOf(lhsExceptionType)) > (indexOfRhsType = new ArrayList<Type>(lhsTypeclosure).indexOf(rhsExceptionType))) {
            return 1;
        }
        return -1;
    }

    private int comparePrecedence(int lhs, int rhs, boolean isLhsBefore) {
        if (!isLhsBefore) {
            return lhs - rhs;
        }
        return (lhs - rhs) * -1;
    }
}

