/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config.converter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.function.BiFunction;
import org.apache.deltaspike.core.api.config.Config;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.apache.deltaspike.core.util.ExceptionUtils;

public class CtInjectionBeanConverter<N>
implements BiFunction<Config, String, N> {
    private final Constructor<?> constructor;

    public <N> CtInjectionBeanConverter(Class<N> clazz, Constructor<?> constructor) {
        this.constructor = constructor;
    }

    @Override
    public N apply(Config config, String path) {
        ArrayList params = new ArrayList();
        for (int i = 0; i < this.constructor.getParameters().length; ++i) {
            String paramName;
            Parameter p2 = this.constructor.getParameters()[i];
            ConfigProperty configProperty = p2.getAnnotation(ConfigProperty.class);
            if (configProperty != null) {
                paramName = configProperty.name();
            } else {
                paramName = p2.getName();
                if (paramName.equals("arg" + i)) {
                    throw new IllegalStateException("Config POJO constructor pareameters must be annotated with @ConfigProperty if the class is not compiled with the javac -parameters option!");
                }
            }
            params.add(config.resolve(path + paramName).as(p2.getType()).getValue());
        }
        if (params.stream().allMatch(p -> p == null)) {
            return null;
        }
        try {
            return (N)this.constructor.newInstance(params.toArray(new Object[params.size()]));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw ExceptionUtils.throwAsRuntimeException(e);
        }
    }
}

