/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.config.Config;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.config.ConfigSnapshot;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.impl.config.ConfigImpl;
import org.apache.deltaspike.core.impl.config.ConfigResolverContext;
import org.apache.deltaspike.core.impl.config.ConfigSnapshotImpl;
import org.apache.deltaspike.core.spi.config.ConfigSource;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.core.util.ProjectStageProducer;

public class TypedResolverImpl<T>
implements ConfigResolver.UntypedResolver<T> {
    private static final Logger LOG = Logger.getLogger(TypedResolverImpl.class.getName());
    private final ConfigImpl config;
    private String keyOriginal;
    private String keyResolved;
    private Type configEntryType = String.class;
    private boolean withDefault = false;
    private T defaultValue;
    private boolean projectStageAware = true;
    private String propertyParameter;
    private String parameterValue;
    private boolean strictly = false;
    private boolean isList = false;
    private ConfigResolver.Converter<?> converter;
    private boolean evaluateVariables = false;
    private boolean logChanges = false;
    private ConfigResolver.ConfigChanged<T> valueChangedCallback = null;
    private long cacheTimeMs = -1L;
    private volatile long reloadAfter = -1L;
    private long lastReloadedAt = -1L;
    private T lastValue = null;
    private BiFunction<Config, String, ?> beanConverter = null;

    TypedResolverImpl(ConfigImpl config, String propertyName) {
        this.config = config;
        this.keyOriginal = propertyName;
    }

    @Override
    public <N> ConfigResolver.TypedResolver<N> as(Class<N> clazz) {
        this.configEntryType = clazz;
        return this;
    }

    @Override
    public ConfigResolver.TypedResolver<List<T>> asList() {
        this.isList = true;
        TypedResolverImpl listTypedResolver = this;
        if (this.defaultValue == null) {
            return listTypedResolver.withDefault(Collections.emptyList());
        }
        return listTypedResolver;
    }

    @Override
    public <N> ConfigResolver.TypedResolver<N> as(Class<N> clazz, ConfigResolver.Converter<N> converter) {
        this.configEntryType = clazz;
        this.converter = converter;
        return this;
    }

    @Override
    public <N> ConfigResolver.TypedResolver<N> as(Type clazz, ConfigResolver.Converter<N> converter) {
        this.configEntryType = clazz;
        this.converter = converter;
        return this;
    }

    @Override
    public <N> ConfigResolver.TypedResolver<N> asBean(Class<N> clazz) {
        return this.asBean(clazz, this.config.getBeanConverter().detectConverter(clazz));
    }

    @Override
    public <N> ConfigResolver.TypedResolver<N> asBean(Class<N> clazz, BiFunction<Config, String, N> beanConverter) {
        this.configEntryType = clazz;
        this.beanConverter = beanConverter;
        return this;
    }

    @Override
    public ConfigResolver.TypedResolver<T> withDefault(T value) {
        this.defaultValue = value;
        this.withDefault = true;
        return this;
    }

    @Override
    public ConfigResolver.TypedResolver<T> withStringDefault(String value) {
        if (value == null || value.isEmpty()) {
            throw new RuntimeException("Empty String or null supplied as string-default value for property " + this.keyOriginal);
        }
        this.defaultValue = this.isList ? this.splitAndConvertListValue(value) : this.convert(value);
        this.withDefault = true;
        return this;
    }

    @Override
    public ConfigResolver.TypedResolver<T> cacheFor(TimeUnit timeUnit, long value) {
        this.cacheTimeMs = timeUnit.toMillis(value);
        return this;
    }

    @Override
    public ConfigResolver.TypedResolver<T> parameterizedBy(String propertyName) {
        String parameterValue;
        this.propertyParameter = propertyName;
        if (this.propertyParameter != null && !this.propertyParameter.isEmpty() && (parameterValue = (String)ConfigResolver.resolve(this.propertyParameter).withCurrentProjectStage(this.projectStageAware).getValue()) != null && !parameterValue.isEmpty()) {
            this.parameterValue = parameterValue;
        }
        return this;
    }

    @Override
    public ConfigResolver.TypedResolver<T> withCurrentProjectStage(boolean with) {
        this.projectStageAware = with;
        return this;
    }

    @Override
    public ConfigResolver.TypedResolver<T> strictly(boolean strictly) {
        this.strictly = strictly;
        return this;
    }

    @Override
    public ConfigResolver.TypedResolver<T> evaluateVariables(boolean evaluateVariables) {
        this.evaluateVariables = evaluateVariables;
        return this;
    }

    @Override
    public ConfigResolver.TypedResolver<T> logChanges(boolean logChanges) {
        this.logChanges = logChanges;
        return this;
    }

    @Override
    public ConfigResolver.TypedResolver<T> onChange(ConfigResolver.ConfigChanged<T> valueChangedCallback) {
        this.valueChangedCallback = valueChangedCallback;
        return this;
    }

    @Override
    public T getValue(ConfigSnapshot snapshot) {
        ConfigSnapshotImpl snapshotImpl = (ConfigSnapshotImpl)snapshot;
        if (!snapshotImpl.getConfigValues().containsKey(this)) {
            throw new IllegalArgumentException("The TypedResolver for key " + this.getKey() + " does not belong the given ConfigSnapshot!");
        }
        return (T)snapshotImpl.getConfigValues().get(this);
    }

    @Override
    public T getValue() {
        T value;
        long lastCfgChange;
        long now = -1L;
        if (this.cacheTimeMs > 0L && (now = System.nanoTime()) <= this.reloadAfter && (lastCfgChange = this.config.getLastChanged()) < this.lastReloadedAt) {
            return this.lastValue;
        }
        if (this.beanConverter != null) {
            value = this.getValueByBeanConverter(this.beanConverter);
        } else {
            String valueStr = this.resolveStringValue();
            value = this.isList ? this.splitAndConvertListValue(valueStr) : this.convert(valueStr);
            if (this.withDefault) {
                ConfigResolverContext configResolverContext = new ConfigResolverContext().setEvaluateVariables(this.evaluateVariables).setProjectStageAware(this.projectStageAware);
                value = this.fallbackToDefaultIfEmpty(this.keyResolved, value, this.defaultValue, configResolverContext);
                if (this.isList && String.class.isInstance(value)) {
                    value = this.splitAndConvertListValue((String)String.class.cast(value));
                }
            }
            if ((this.logChanges || this.valueChangedCallback != null) && (value != null && !value.equals(this.lastValue) || value == null && this.lastValue != null)) {
                if (this.logChanges) {
                    LOG.log(Level.INFO, "New value {0} for key {1}.", new Object[]{ConfigResolver.filterConfigValueForLog(this.keyOriginal, valueStr), this.keyOriginal});
                }
                if (this.valueChangedCallback != null) {
                    this.valueChangedCallback.onValueChange(this.keyOriginal, this.lastValue, value);
                }
            }
        }
        this.lastValue = value;
        if (this.cacheTimeMs > 0L) {
            this.reloadAfter = now + TimeUnit.MILLISECONDS.toNanos(this.cacheTimeMs);
            this.lastReloadedAt = now;
        }
        return value;
    }

    private T getValueByBeanConverter(BiFunction<Config, String, ?> beanConverter) {
        for (int tries = 1; tries < 5; ++tries) {
            long startReadLastChanged = this.config.getLastChanged();
            Object value = beanConverter.apply(this.config, this.keyOriginal + ".");
            if (startReadLastChanged != this.config.getLastChanged()) continue;
            return (T)value;
        }
        throw new IllegalStateException("Could not resolve ConfigTransaction as underlying values are permanently changing!");
    }

    private T splitAndConvertListValue(String valueStr) {
        if (valueStr == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        StringBuilder currentValue = new StringBuilder();
        int length = valueStr.length();
        for (int i = 0; i < length; ++i) {
            char c = valueStr.charAt(i);
            if (c == '\\') {
                if (i >= length - 1) continue;
                char nextC = valueStr.charAt(i + 1);
                currentValue.append(nextC);
                ++i;
                continue;
            }
            if (c == ',') {
                String trimedVal = currentValue.toString().trim();
                if (trimedVal.length() > 0) {
                    list.add(this.convert(trimedVal));
                }
                currentValue.setLength(0);
                continue;
            }
            currentValue.append(c);
        }
        String trimedVal = currentValue.toString().trim();
        if (trimedVal.length() > 0) {
            list.add(this.convert(trimedVal));
        }
        return (T)list;
    }

    @Override
    public String getKey() {
        return this.keyOriginal;
    }

    @Override
    public String getResolvedKey() {
        return this.keyResolved;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    private String resolveStringValue() {
        ProjectStage ps = null;
        String value = null;
        this.keyResolved = this.keyOriginal;
        int keySuffices = 0;
        if (this.propertyParameter != null && !this.propertyParameter.isEmpty()) {
            if (this.parameterValue != null && !this.parameterValue.isEmpty()) {
                this.keyResolved = this.keyResolved + "." + this.parameterValue;
                ++keySuffices;
            } else if (this.strictly) {
                return null;
            }
        }
        if (this.projectStageAware) {
            ps = this.getProjectStage();
            this.keyResolved = this.keyResolved + "." + ps;
            ++keySuffices;
        }
        if ((value = this.getPropertyValue(this.keyResolved)) == null && !this.strictly) {
            switch (keySuffices) {
                case 2: {
                    this.keyResolved = this.keyOriginal + "." + this.parameterValue;
                    value = this.getPropertyValue(this.keyResolved);
                    if (value != null) {
                        return value;
                    }
                    ps = this.getProjectStage();
                    this.keyResolved = this.keyOriginal + "." + ps;
                    value = this.getPropertyValue(this.keyResolved);
                    if (value != null) {
                        return value;
                    }
                }
                case 1: {
                    this.keyResolved = this.keyOriginal;
                    value = this.getPropertyValue(this.keyResolved);
                    return value;
                }
            }
            return null;
        }
        return value;
    }

    private T convert(String value) {
        if (value == null) {
            return null;
        }
        Object result = null;
        if (this.converter != null) {
            try {
                result = this.converter.convert(value);
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsRuntimeException(e);
            }
        } else if (String.class.equals((Object)this.configEntryType)) {
            result = value;
        } else if (Class.class.equals((Object)this.configEntryType)) {
            result = ClassUtils.tryToLoadClassForName(value);
        } else if (Boolean.class.equals((Object)this.configEntryType)) {
            Boolean isTrue = "TRUE".equalsIgnoreCase(value);
            isTrue = isTrue | "1".equalsIgnoreCase(value);
            isTrue = isTrue | "YES".equalsIgnoreCase(value);
            isTrue = isTrue | "Y".equalsIgnoreCase(value);
            isTrue = isTrue | "JA".equalsIgnoreCase(value);
            isTrue = isTrue | "J".equalsIgnoreCase(value);
            isTrue = isTrue | "OUI".equalsIgnoreCase(value);
            result = isTrue;
        } else if (Integer.class.equals((Object)this.configEntryType)) {
            result = Integer.parseInt(value);
        } else if (Long.class.equals((Object)this.configEntryType)) {
            result = Long.parseLong(value);
        } else if (Float.class.equals((Object)this.configEntryType)) {
            result = Float.valueOf(Float.parseFloat(value));
        } else if (Double.class.equals((Object)this.configEntryType)) {
            result = Double.parseDouble(value);
        }
        return (T)result;
    }

    private <T> T fallbackToDefaultIfEmpty(String key, T value, T defaultValue, ConfigResolverContext configResolverContext) {
        if (value == null || value instanceof String && ((String)value).isEmpty()) {
            if (configResolverContext != null && defaultValue instanceof String && configResolverContext.isEvaluateVariables()) {
                defaultValue = this.resolveVariables((String)defaultValue);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "no configured value found for key {0}, using default value {1}.", new Object[]{key, defaultValue});
            }
            return defaultValue;
        }
        return value;
    }

    private String resolveVariables(String value) {
        String varName;
        int endVar;
        int startVar = 0;
        while ((startVar = value.indexOf("${", startVar)) >= 0 && (endVar = value.indexOf("}", startVar)) > 0 && !(varName = value.substring(startVar + 2, endVar)).isEmpty()) {
            try {
                String variableValue = (String)new TypedResolverImpl<T>(this.config, varName).withCurrentProjectStage(this.projectStageAware).evaluateVariables(true).getValue();
                if (variableValue != null) {
                    value = value.replace("${" + varName + "}", variableValue);
                }
            }
            catch (StackOverflowError soe) {
                LOG.severe("Recursive variable resolution detected for " + varName);
                throw soe;
            }
            ++startVar;
        }
        return value;
    }

    private ProjectStage getProjectStage() {
        return ProjectStageProducer.getInstance().getProjectStage();
    }

    private String getPropertyValue(String key) {
        for (ConfigSource configSource : this.config.getConfigSources()) {
            String value = configSource.getPropertyValue(key);
            if (value != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "found value {0} for key {1} in ConfigSource {2}.", new Object[]{this.config.filterConfigValue(key, value, true), key, configSource.getConfigName()});
                }
                if (this.evaluateVariables) {
                    value = this.resolveVariables(value);
                }
                return this.config.filterConfigValue(key, value, false);
            }
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.log(Level.FINER, "NO value found for key {0} in ConfigSource {1}.", new Object[]{key, configSource.getConfigName()});
        }
        return null;
    }
}

