/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import jakarta.management.openmbean.CompositeData;
import jakarta.management.openmbean.CompositeDataSupport;
import jakarta.management.openmbean.CompositeType;
import jakarta.management.openmbean.OpenDataException;
import jakarta.management.openmbean.OpenType;
import jakarta.management.openmbean.SimpleType;
import jakarta.management.openmbean.TabularData;
import jakarta.management.openmbean.TabularDataSupport;
import jakarta.management.openmbean.TabularType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.impl.config.DeltaSpikeConfigInfoMBean;
import org.apache.deltaspike.core.spi.config.ConfigSource;

public class DeltaSpikeConfigInfo
implements DeltaSpikeConfigInfoMBean {
    private final ClassLoader appConfigClassLoader;

    public DeltaSpikeConfigInfo(ClassLoader appConfigClassLoader) {
        this.appConfigClassLoader = appConfigClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getConfigSourcesAsString() {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.appConfigClassLoader);
            ConfigSource[] configSources = ConfigResolver.getConfigSources();
            ArrayList<String> configSourceInfo = new ArrayList<String>();
            for (ConfigSource configSource : configSources) {
                configSourceInfo.add(Integer.toString(configSource.getOrdinal()) + " - " + configSource.getConfigName());
            }
            Object[] objectArray = configSourceInfo.toArray(new String[configSourceInfo.size()]);
            return objectArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getConfigEntriesAsString() {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.appConfigClassLoader);
            List<ConfigEntry> configEntries = this.calculateConfigEntries();
            String[] configArray = new String[configEntries.size()];
            for (int i = 0; i < configEntries.size(); ++i) {
                ConfigEntry configEntry = configEntries.get(i);
                configArray[i] = configEntry.getKey() + " = " + configEntry.getValue() + " - picked up from: " + configEntry.getFromConfigSource();
            }
            String[] stringArray = configArray;
            return stringArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    @Override
    public TabularData getConfigEntries() {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.appConfigClassLoader);
            List<ConfigEntry> configEntries = this.calculateConfigEntries();
            String[] configArray = new String[configEntries.size()];
            for (int i = 0; i < configEntries.size(); ++i) {
                ConfigEntry configEntry = configEntries.get(i);
                configArray[i] = configEntry.getKey() + " = " + configEntry.getValue() + " - picked up from: " + configEntry.getFromConfigSource();
            }
            String typeName = "ConfigEntries";
            OpenType[] types = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
            String[] keys = new String[]{"Key", "Value", "fromConfigSource"};
            CompositeType ct = new CompositeType(typeName, typeName, keys, keys, types);
            TabularType type = new TabularType(typeName, typeName, ct, keys);
            TabularDataSupport configEntryInfo = new TabularDataSupport(type);
            ConfigSource[] configSources = ConfigResolver.getConfigSources();
            for (ConfigEntry configEntry : configEntries) {
                configEntryInfo.put((CompositeData)new CompositeDataSupport(ct, keys, new Object[]{configEntry.getKey(), configEntry.getValue(), configEntry.getFromConfigSource()}));
            }
            TabularDataSupport tabularDataSupport = configEntryInfo;
            return tabularDataSupport;
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    @Override
    public TabularData getConfigSources() {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            TabularDataSupport configSources;
            Thread.currentThread().setContextClassLoader(this.appConfigClassLoader);
            String typeName = "ConfigSources";
            OpenType[] types = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING};
            String[] keys = new String[]{"Ordinal", "ConfigSource"};
            CompositeType ct = new CompositeType(typeName, typeName, keys, keys, types);
            TabularType type = new TabularType(typeName, typeName, ct, keys);
            TabularDataSupport configSourceInfo = new TabularDataSupport(type);
            for (TabularDataSupport configSource : configSources = ConfigResolver.getConfigSources()) {
                configSourceInfo.put((CompositeData)new CompositeDataSupport(ct, keys, new Object[]{configSource.getOrdinal(), configSource.getConfigName()}));
            }
            TabularDataSupport tabularDataSupport = configSourceInfo;
            return tabularDataSupport;
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    private List<ConfigEntry> calculateConfigEntries() {
        Map<String, String> allProperties = ConfigResolver.getAllProperties();
        ArrayList<ConfigEntry> configEntries = new ArrayList<ConfigEntry>(allProperties.size());
        ConfigSource[] configSources = ConfigResolver.getConfigSources();
        for (Map.Entry<String, String> configEntry : allProperties.entrySet()) {
            String key = configEntry.getKey();
            String value = ConfigResolver.filterConfigValueForLog(key, ConfigResolver.getProjectStageAwarePropertyValue(key));
            String fromConfigSource = this.getFromConfigSource(configSources, key);
            configEntries.add(new ConfigEntry(key, value, fromConfigSource));
        }
        return configEntries;
    }

    private String getFromConfigSource(ConfigSource[] configSources, String key) {
        for (ConfigSource configSource : configSources) {
            if (configSource.getPropertyValue(key) == null) continue;
            return configSource.getConfigName();
        }
        return null;
    }

    private class ConfigEntry {
        private final String key;
        private final String value;
        private final String fromConfigSource;

        ConfigEntry(String key, String value, String fromConfigSource) {
            this.key = key;
            this.value = value;
            this.fromConfigSource = fromConfigSource;
        }

        String getKey() {
            return this.key;
        }

        String getValue() {
            return this.value;
        }

        String getFromConfigSource() {
            return this.fromConfigSource;
        }
    }
}

