/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.deltaspike.core.api.config.Config;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.impl.config.ConfigHelperImpl;
import org.apache.deltaspike.core.impl.config.ConfigImpl;
import org.apache.deltaspike.core.util.ClassUtils;

public class ConfigProviderImpl
implements ConfigResolver.ConfigProvider {
    private static Map<ClassLoader, ConfigImpl> configs = new ConcurrentHashMap<ClassLoader, ConfigImpl>();

    @Override
    public Config getConfig() {
        ClassLoader cl = ClassUtils.getClassLoader(null);
        return this.getConfig(cl);
    }

    @Override
    public Config getConfig(ClassLoader cl) {
        ConfigImpl config = configs.get(cl);
        if (config == null) {
            config = new ConfigImpl(cl);
            config.init();
            ConfigImpl oldConfig = configs.put(cl, config);
            if (oldConfig != null) {
                config = oldConfig;
            }
        }
        return config;
    }

    @Override
    public void releaseConfig(ClassLoader cl) {
        ConfigImpl oldConfig = configs.remove(cl);
        if (oldConfig != null) {
            oldConfig.release();
        }
        Iterator<Map.Entry<ClassLoader, ConfigImpl>> it = configs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ClassLoader, ConfigImpl> cfgEntry = it.next();
            if (!this.isChildClassLoader(cl, cfgEntry.getKey())) continue;
            cfgEntry.getValue().release();
            it.remove();
        }
    }

    @Override
    public ConfigResolver.ConfigHelper getHelper() {
        return new ConfigHelperImpl();
    }

    private boolean isChildClassLoader(ClassLoader configClassLoader, ClassLoader suspect) {
        ClassLoader suspectParentCl = suspect.getParent();
        if (suspectParentCl == null) {
            return false;
        }
        if (suspectParentCl == configClassLoader) {
            return true;
        }
        return this.isChildClassLoader(configClassLoader, suspectParentCl);
    }
}

