/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.config.Config;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.config.ConfigSnapshot;
import org.apache.deltaspike.core.impl.config.ConfigSnapshotImpl;
import org.apache.deltaspike.core.impl.config.TypedResolverImpl;
import org.apache.deltaspike.core.impl.config.converter.BeanConverterFactory;
import org.apache.deltaspike.core.spi.config.ConfigFilter;
import org.apache.deltaspike.core.spi.config.ConfigSource;
import org.apache.deltaspike.core.spi.config.ConfigSourceProvider;
import org.apache.deltaspike.core.util.ServiceUtils;

public class ConfigImpl
implements Config {
    public static final int MAX_CONFIG_RETRIES = 5;
    private static final Logger LOG = Logger.getLogger(ConfigImpl.class.getName());
    private final ClassLoader classLoader;
    private ConfigSource[] configSources;
    private List<ConfigFilter> configFilters;
    private volatile long lastChanged = 0L;
    private BeanConverterFactory beanConverter;

    public ConfigImpl(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.beanConverter = new BeanConverterFactory();
    }

    void init() {
        List<ConfigSource> appConfigSources = ServiceUtils.loadServiceImplementations(ConfigSource.class, false, this.classLoader);
        List<ConfigSourceProvider> configSourceProviderServiceLoader = ServiceUtils.loadServiceImplementations(ConfigSourceProvider.class, false, this.classLoader);
        for (ConfigSourceProvider configSourceProvider : configSourceProviderServiceLoader) {
            appConfigSources.addAll(configSourceProvider.getConfigSources());
        }
        this.addConfigSources(appConfigSources);
        if (LOG.isLoggable(Level.FINE)) {
            for (ConfigSource cs : appConfigSources) {
                LOG.log(Level.FINE, "Adding ordinal {0} ConfigSource {1}", new Object[]{cs.getOrdinal(), cs.getConfigName()});
            }
        }
        List<ConfigFilter> configFilters = ServiceUtils.loadServiceImplementations(ConfigFilter.class, false, this.classLoader);
        this.configFilters = new CopyOnWriteArrayList<ConfigFilter>(configFilters);
    }

    void release() {
        for (ConfigSource configSource : this.configSources) {
            this.close(configSource);
        }
        for (ConfigFilter configFilter : this.configFilters) {
            this.close(configFilter);
        }
    }

    private void close(Object o) {
        if (o instanceof AutoCloseable) {
            try {
                ((AutoCloseable)o).close();
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "Exception while closing " + o.toString(), e);
            }
        }
    }

    @Override
    public ConfigSource[] getConfigSources() {
        return this.configSources;
    }

    public BeanConverterFactory getBeanConverter() {
        return this.beanConverter;
    }

    @Override
    public ConfigSnapshot snapshotFor(ConfigResolver.TypedResolver<?> ... typedResolvers) {
        for (int tries = 1; tries < 5; ++tries) {
            HashMap configValues = new HashMap();
            long startReadLastChanged = this.lastChanged;
            for (ConfigResolver.TypedResolver<?> typedResolver : typedResolvers) {
                configValues.put(typedResolver, typedResolver.getValue());
            }
            if (startReadLastChanged != this.lastChanged) continue;
            return new ConfigSnapshotImpl(configValues);
        }
        throw new IllegalStateException("Could not resolve ConfigTransaction as underlying values are permanently changing!");
    }

    @Override
    public void addConfigSources(List<ConfigSource> configSourcesToAdd) {
        if (configSourcesToAdd == null || configSourcesToAdd.isEmpty()) {
            return;
        }
        ArrayList<ConfigSource> allConfigSources = new ArrayList<ConfigSource>();
        if (this.configSources != null) {
            for (ConfigSource configSource : this.configSources) {
                allConfigSources.add(configSource);
            }
        }
        for (ConfigSource configSourceToAdd : configSourcesToAdd) {
            configSourceToAdd.setOnAttributeChange(this::onAttributeChange);
            allConfigSources.add(configSourceToAdd);
        }
        this.configSources = this.sortDescending(allConfigSources);
    }

    @Override
    public List<ConfigFilter> getConfigFilters() {
        return Collections.unmodifiableList(this.configFilters);
    }

    @Override
    public void addConfigFilter(ConfigFilter configFilter) {
        this.configFilters.add(configFilter);
    }

    @Override
    public String filterConfigValue(String key, String value, boolean forLog) {
        String filteredValue = value;
        for (ConfigFilter filter : this.configFilters) {
            filteredValue = forLog ? filter.filterValueForLog(key, filteredValue) : filter.filterValue(key, filteredValue);
        }
        return filteredValue;
    }

    @Override
    public ConfigResolver.UntypedResolver<String> resolve(String name) {
        return new TypedResolverImpl<String>(this, name);
    }

    private ConfigSource[] sortDescending(List<ConfigSource> configSources) {
        Collections.sort(configSources, new Comparator<ConfigSource>(){

            @Override
            public int compare(ConfigSource configSource1, ConfigSource configSource2) {
                int o2;
                int o1 = configSource1.getOrdinal();
                if (o1 == (o2 = configSource2.getOrdinal())) {
                    return configSource1.getConfigName().compareTo(configSource2.getConfigName());
                }
                return o1 > o2 ? -1 : 1;
            }
        });
        return configSources.toArray(new ConfigSource[configSources.size()]);
    }

    public void onAttributeChange(Set<String> attributesChanged) {
        long l;
        long newLastChanged = System.nanoTime();
        if (this.lastChanged >= newLastChanged) {
            long l2 = this.lastChanged;
            l = l2;
            this.lastChanged = l2 + 1L;
        } else {
            l = newLastChanged;
        }
        this.lastChanged = l;
    }

    public long getLastChanged() {
        return this.lastChanged;
    }
}

