/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.resourceloader;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.resourceloader.InjectableResource;
import org.apache.deltaspike.core.api.resourceloader.InjectableResourceProvider;

public abstract class AbstractResourceProvider
implements InjectableResourceProvider {
    private static final Logger logger = Logger.getLogger(AbstractResourceProvider.class.getName());
    @Inject
    @Any
    private Instance<InjectionPoint> injectionPoint;

    protected boolean isXml(String fileName) {
        return fileName.endsWith(".xml");
    }

    protected InjectionPoint getInjectionPoint() {
        return (InjectionPoint)this.injectionPoint.get();
    }

    protected Set<Annotation> getAnnotations() {
        return this.getInjectionPoint().getAnnotated().getAnnotations();
    }

    protected void loadInputStreamToProperties(InputStream inputStream, Properties properties, String name) {
        boolean isXml = this.isXml(name);
        try {
            if (isXml) {
                properties.loadFromXML(inputStream);
            } else {
                properties.load(inputStream);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to read resource " + name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties readProperties(InjectableResource injectableResource) {
        Properties properties = new Properties();
        String name = injectableResource.location();
        InputStream inputStream = null;
        try {
            inputStream = this.readStream(injectableResource);
            this.loadInputStreamToProperties(inputStream, properties, name);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            block8: {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        if (!logger.isLoggable(Level.FINE)) break block8;
                        logger.log(Level.FINE, "Problem closing resource.", e);
                    }
                }
            }
        }
    }

    @Override
    public List<InputStream> readStreams(InjectableResource injectableResource) {
        return Collections.singletonList(this.readStream(injectableResource));
    }
}

