/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.exception.control.event;

import jakarta.enterprise.inject.Typed;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Typed
public class ExceptionToCatchEvent
implements Serializable {
    private static final long serialVersionUID = 2646115104528108266L;
    private Throwable exception;
    private boolean handled;
    private transient Set<Annotation> qualifiers;
    private boolean optional;

    public ExceptionToCatchEvent(Throwable exception, Annotation ... qualifiers) {
        this.exception = exception;
        this.qualifiers = new HashSet<Annotation>();
        Collections.addAll(this.qualifiers, qualifiers);
        this.optional = false;
    }

    public ExceptionToCatchEvent(Throwable exception) {
        this.exception = exception;
        this.qualifiers = Collections.emptySet();
        this.optional = false;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public Set<Annotation> getQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }
}

