/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.partialbean.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;
import org.apache.deltaspike.core.util.metadata.builder.ContextualLifecycle;
import org.apache.deltaspike.partialbean.impl.MethodHandlerProxy;
import org.apache.deltaspike.partialbean.impl.PartialBeanAbstractMethodHandler;

class PartialBeanLifecycle<T, H extends InvocationHandler>
implements ContextualLifecycle<T> {
    private final Class<? extends T> partialBeanProxyClass;
    private final InjectionTarget<T> partialBeanInjectionTarget;
    private final Class<H> handlerClass;
    private CreationalContext<?> creationalContextOfDependentHandler;
    private final boolean isInterfaceMode;
    private final boolean valid;

    PartialBeanLifecycle(Class<T> partialBeanClass, Class<H> handlerClass, AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        this.handlerClass = handlerClass;
        if (partialBeanClass.isInterface()) {
            this.isInterfaceMode = true;
            this.partialBeanInjectionTarget = null;
            this.partialBeanProxyClass = partialBeanClass;
        } else {
            this.isInterfaceMode = false;
            AnnotatedTypeBuilder partialBeanTypeBuilder = new AnnotatedTypeBuilder().readFromType(partialBeanClass);
            this.partialBeanInjectionTarget = beanManager.createInjectionTarget(partialBeanTypeBuilder.create());
            try {
                Object proxyFactory = ClassUtils.tryToInstantiateClassForName((String)"javassist.util.proxy.ProxyFactory");
                if (proxyFactory == null) {
                    afterBeanDiscovery.addDefinitionError((Throwable)new IllegalStateException("For using abstract classes as partial beans,it's needed to add the lib 'javassist' to the classpath."));
                    this.partialBeanProxyClass = null;
                    this.valid = false;
                    return;
                }
                Method setSuperclassMethod = proxyFactory.getClass().getDeclaredMethod("setSuperclass", Class.class);
                setSuperclassMethod.invoke(proxyFactory, partialBeanClass);
                Method createClassMethod = proxyFactory.getClass().getDeclaredMethod("createClass", new Class[0]);
                this.partialBeanProxyClass = ((Class)createClassMethod.invoke(proxyFactory, new Object[0])).asSubclass(partialBeanClass);
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
        this.valid = true;
    }

    public T create(Bean bean, CreationalContext creationalContext) {
        try {
            H handlerInstance = this.createHandlerInstance();
            T instance = this.createPartialBeanProxyInstance(handlerInstance);
            if (this.partialBeanInjectionTarget != null) {
                this.partialBeanInjectionTarget.inject(instance, creationalContext);
                this.partialBeanInjectionTarget.postConstruct(instance);
            }
            return instance;
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException((Throwable)e);
            return null;
        }
    }

    private T createPartialBeanProxyInstance(H handlerInstance) throws Exception {
        Object instance;
        if (this.isInterfaceMode) {
            instance = Proxy.newProxyInstance(ClassUtils.getClassLoader((Object)this), new Class[]{this.partialBeanProxyClass}, handlerInstance);
        } else {
            instance = this.partialBeanProxyClass.newInstance();
            Class methodHandlerClass = ClassUtils.tryToLoadClassForName((String)"javassist.util.proxy.MethodHandler");
            Method setHandlerMethod = ClassUtils.tryToLoadClassForName((String)"javassist.util.proxy.ProxyObject").getDeclaredMethod("setHandler", methodHandlerClass);
            MethodHandlerProxy methodHandlerProxy = new MethodHandlerProxy();
            methodHandlerProxy.setPartialBeanMethodHandler(new PartialBeanAbstractMethodHandler<H>(handlerInstance));
            Object methodHandler = Proxy.newProxyInstance(ClassUtils.getClassLoader((Object)this), new Class[]{methodHandlerClass}, (InvocationHandler)methodHandlerProxy);
            setHandlerMethod.invoke(instance, methodHandler);
        }
        return instance;
    }

    private H createHandlerInstance() {
        Set handlerBeans = BeanProvider.getBeanDefinitions(this.handlerClass, (boolean)false, (boolean)true);
        if (handlerBeans.size() != 1) {
            throw new IllegalStateException(handlerBeans.size() + " beans found for " + this.handlerClass);
        }
        Bean handlerBean = (Bean)handlerBeans.iterator().next();
        BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
        CreationalContext creationalContextOfHandler = beanManager.createCreationalContext((Contextual)handlerBean);
        InvocationHandler handlerInstance = (InvocationHandler)beanManager.getReference(handlerBean, this.handlerClass, creationalContextOfHandler);
        if (handlerBean.getScope().equals(Dependent.class)) {
            this.creationalContextOfDependentHandler = creationalContextOfHandler;
        }
        return (H)handlerInstance;
    }

    public void destroy(Bean<T> bean, T instance, CreationalContext<T> creationalContext) {
        if (this.partialBeanInjectionTarget != null) {
            this.partialBeanInjectionTarget.preDestroy(instance);
        }
        if (this.creationalContextOfDependentHandler != null) {
            this.creationalContextOfDependentHandler.release();
        }
        creationalContext.release();
    }

    boolean isValid() {
        return this.valid;
    }
}

