/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.partialbean.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.bean.BeanBuilder;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;
import org.apache.deltaspike.partialbean.api.PartialBeanBinding;
import org.apache.deltaspike.partialbean.impl.PartialBeanLifecycle;

public class PartialBeanBindingExtension
implements Extension,
Deactivatable {
    private static final Logger LOG = Logger.getLogger(PartialBeanBindingExtension.class.getName());
    private Boolean isActivated = true;
    private Map<Class<?>, Class<? extends Annotation>> partialBeans = new HashMap();
    private Map<Class<? extends Annotation>, Class<? extends InvocationHandler>> partialBeanHandlers = new HashMap<Class<? extends Annotation>, Class<? extends InvocationHandler>>();
    private IllegalStateException definitionError;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    public <X> void findInvocationHandlerBindings(@Observes ProcessAnnotatedType<X> pat, BeanManager beanManager) {
        if (!this.isActivated.booleanValue() || this.definitionError != null) {
            return;
        }
        Class beanClass = pat.getAnnotatedType().getJavaClass();
        Class<Annotation> bindingAnnotationClass = this.getInvocationHandlerBindingAnnotationClass(pat);
        if (bindingAnnotationClass == null) {
            return;
        }
        if (beanClass.isInterface() || Modifier.isAbstract(beanClass.getModifiers())) {
            this.partialBeans.put(beanClass, bindingAnnotationClass);
        } else if (InvocationHandler.class.isAssignableFrom(beanClass)) {
            this.validateInvocationHandler(beanClass, bindingAnnotationClass);
            this.partialBeanHandlers.put(bindingAnnotationClass, beanClass);
        } else {
            this.definitionError = new IllegalStateException(beanClass.getName() + " is annotated with @" + bindingAnnotationClass.getName() + " and therefore has to be " + "an abstract class, an interface or an implementation of " + InvocationHandler.class.getName());
        }
    }

    public <X> void createBeans(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        if (this.definitionError != null) {
            afterBeanDiscovery.addDefinitionError((Throwable)this.definitionError);
            return;
        }
        for (Map.Entry<Class<?>, Class<Annotation>> partialBeanEntry : this.partialBeans.entrySet()) {
            Bean<?> partialBean = this.createPartialBean(partialBeanEntry.getKey(), partialBeanEntry.getValue(), afterBeanDiscovery, beanManager);
            if (partialBean == null) continue;
            afterBeanDiscovery.addBean(partialBean);
        }
        this.partialBeans.clear();
        this.partialBeanHandlers.clear();
    }

    protected <T> Bean<T> createPartialBean(Class<T> beanClass, Class<? extends Annotation> bindingAnnotationClass, AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        Class<? extends InvocationHandler> invocationHandlerClass = this.partialBeanHandlers.get(bindingAnnotationClass);
        if (invocationHandlerClass == null) {
            afterBeanDiscovery.addDefinitionError((Throwable)new IllegalStateException("A class which implements " + InvocationHandler.class.getName() + " and is annotated with @" + bindingAnnotationClass.getName() + " is needed as a handler for " + beanClass.getName() + ". See the documentation about @" + PartialBeanBinding.class.getName() + "."));
            return null;
        }
        AnnotatedType annotatedType = new AnnotatedTypeBuilder().readFromType(beanClass).create();
        PartialBeanLifecycle<T, InvocationHandler> beanLifecycle = new PartialBeanLifecycle<T, InvocationHandler>(beanClass, invocationHandlerClass, afterBeanDiscovery, beanManager);
        if (!beanLifecycle.isValid()) {
            return null;
        }
        BeanBuilder beanBuilder = new BeanBuilder(beanManager).readFromType(annotatedType).passivationCapable(true).beanLifecycle(beanLifecycle);
        return beanBuilder.create();
    }

    protected <X> Class<? extends Annotation> getInvocationHandlerBindingAnnotationClass(ProcessAnnotatedType<X> pat) {
        for (Annotation annotation : pat.getAnnotatedType().getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(PartialBeanBinding.class)) continue;
            return annotation.annotationType();
        }
        return null;
    }

    protected <X> void validateInvocationHandler(Class<X> beanClass, Class<? extends Annotation> bindingAnnotationClass) {
        Class<? extends InvocationHandler> alreadyFoundHandler = this.partialBeanHandlers.get(bindingAnnotationClass);
        if (alreadyFoundHandler != null) {
            this.definitionError = new IllegalStateException("Multiple handlers found for " + bindingAnnotationClass.getName() + " (" + alreadyFoundHandler.getName() + " and " + beanClass.getName() + ")");
        }
    }
}

