/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.deltaspike.jsf.impl.message;

import org.apache.deltaspike.core.api.message.MessageContext;
import org.apache.deltaspike.core.impl.message.DefaultMessageResolver;

import javax.enterprise.inject.Specializes;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.List;

@Specializes
public class JsfMessageResolver extends DefaultMessageResolver
{
    @Override
    protected List<String> getMessageSources(MessageContext messageContext)
    {
        List<String> result = new ArrayList<String>(super.getMessageSources(messageContext) /*unmodifiable-list*/);

        FacesContext facesContext = FacesContext.getCurrentInstance();

        if (facesContext == null)
        {
            return result;
        }

        String bundleName = facesContext.getApplication().getMessageBundle();

        if (bundleName != null)
        {
            result.add(bundleName);
        }
        result.add(FacesMessage.FACES_MESSAGES); //default messages from jsf

        return result;
    }
}
