/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.impl.transaction.context;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.deltaspike.jpa.api.transaction.TransactionScoped;
import org.apache.deltaspike.jpa.api.transaction.Transactional;
import org.apache.deltaspike.jpa.impl.transaction.context.TransactionBeanEntry;
import org.apache.deltaspike.jpa.impl.transaction.context.TransactionBeanStorage;

public class TransactionContext
implements Context {
    public <T> T get(Contextual<T> component) {
        Map<Contextual, TransactionBeanEntry> transactionBeanEntryMap = TransactionBeanStorage.getInstance().getActiveTransactionContext();
        if (transactionBeanEntryMap == null) {
            TransactionBeanStorage.close();
            throw new ContextNotActiveException("Not accessed within a transactional method - use @" + Transactional.class.getName());
        }
        TransactionBeanEntry transactionBeanEntry = transactionBeanEntryMap.get(component);
        if (transactionBeanEntry != null) {
            return transactionBeanEntry.getContextualInstance();
        }
        return null;
    }

    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        Map<Contextual, TransactionBeanEntry> transactionBeanEntryMap = TransactionBeanStorage.getInstance().getActiveTransactionContext();
        if (transactionBeanEntryMap == null) {
            TransactionBeanStorage.close();
            throw new ContextNotActiveException("Not accessed within a transactional method - use @" + Transactional.class.getName());
        }
        TransactionBeanEntry<Object> transactionBeanEntry = transactionBeanEntryMap.get(component);
        if (transactionBeanEntry != null) {
            return transactionBeanEntry.getContextualInstance();
        }
        Object instance = component.create(creationalContext);
        transactionBeanEntry = new TransactionBeanEntry<Object>(component, instance, creationalContext);
        transactionBeanEntryMap.put(component, transactionBeanEntry);
        return (T)instance;
    }

    public Class<? extends Annotation> getScope() {
        return TransactionScoped.class;
    }

    public boolean isActive() {
        try {
            return TransactionBeanStorage.isOpen() && TransactionBeanStorage.getInstance().getActiveTransactionContext() != null;
        }
        catch (ContextNotActiveException e) {
            return false;
        }
    }
}

