/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import org.apache.deltaspike.data.api.Repository;
import org.apache.deltaspike.data.impl.meta.EntityMetadata;
import org.apache.deltaspike.data.impl.meta.RepositoryMetadata;
import org.apache.deltaspike.data.impl.util.EntityUtils;

@ApplicationScoped
public class EntityMetadataInitializer {
    private static final Logger LOG = Logger.getLogger(EntityMetadataInitializer.class.getName());

    public EntityMetadata init(RepositoryMetadata metadata) {
        EntityMetadata entityMetadata = this.extract(metadata.getRepositoryClass());
        entityMetadata.setPrimaryKeyProperty(EntityUtils.primaryKeyProperty(entityMetadata.getEntityClass()));
        entityMetadata.setVersionProperty(EntityUtils.getVersionProperty(entityMetadata.getEntityClass()));
        entityMetadata.setEntityName(EntityUtils.entityName(entityMetadata.getEntityClass()));
        return entityMetadata;
    }

    private EntityMetadata extract(Class<?> repositoryClass) {
        boolean isEntityClass;
        Repository repository = repositoryClass.getAnnotation(Repository.class);
        Class entityClass = repository.forEntity();
        boolean bl = isEntityClass = !Object.class.equals((Object)entityClass) && EntityUtils.isEntityClass(entityClass);
        if (isEntityClass) {
            return new EntityMetadata(entityClass, EntityUtils.primaryKeyClass(entityClass));
        }
        for (Type inf : repositoryClass.getGenericInterfaces()) {
            EntityMetadata result = this.extractFromType(inf);
            if (result == null) continue;
            return result;
        }
        EntityMetadata entityMetadata = this.extractFromType(repositoryClass.getGenericSuperclass());
        if (entityMetadata != null) {
            return entityMetadata;
        }
        for (Type intf : repositoryClass.getGenericInterfaces()) {
            entityMetadata = this.extractFromType(intf);
            if (entityMetadata == null) continue;
            return entityMetadata;
        }
        if (repositoryClass.getSuperclass() != null) {
            return this.extract(repositoryClass.getSuperclass());
        }
        return null;
    }

    private EntityMetadata extractFromType(Type type) {
        LOG.log(Level.FINER, "extractFrom: type = {0}", type);
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parametrizedType = (ParameterizedType)type;
        Type[] genericTypes = parametrizedType.getActualTypeArguments();
        EntityMetadata result = null;
        for (Type genericType : genericTypes) {
            if (genericType instanceof Class && EntityUtils.isEntityClass((Class)genericType)) {
                result = new EntityMetadata((Class)genericType);
                continue;
            }
            if (result == null || !(genericType instanceof Class)) continue;
            result.setPrimaryKeyClass((Class)genericType);
            return result;
        }
        return result;
    }
}

