/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.FlushModeType;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.data.api.EntityManagerConfig;
import org.apache.deltaspike.data.api.EntityManagerResolver;
import org.apache.deltaspike.data.api.Repository;
import org.apache.deltaspike.data.impl.meta.MethodType;
import org.apache.deltaspike.data.impl.meta.RepositoryEntity;
import org.apache.deltaspike.data.impl.meta.RepositoryMethod;

public class RepositoryComponent {
    private static final Logger log = Logger.getLogger(RepositoryComponent.class.getName());
    private volatile Boolean entityManagerResolverIsNormalScope;
    private final Class<?> repoClass;
    private final RepositoryEntity repositoryEntity;
    private final Class<? extends EntityManagerResolver> entityManagerResolver;
    private final FlushModeType entityManagerFlushMode;
    private final Map<Method, RepositoryMethod> methods = new HashMap<Method, RepositoryMethod>();

    public RepositoryComponent(Class<?> repoClass, RepositoryEntity repositoryEntity) {
        if (repositoryEntity == null) {
            throw new IllegalArgumentException("repositoryEntity cannot be null");
        }
        this.repoClass = repoClass;
        this.repositoryEntity = repositoryEntity;
        this.entityManagerResolver = this.extractEntityManagerResolver(repoClass);
        this.entityManagerFlushMode = this.extractEntityManagerFlushMode(repoClass);
    }

    private void lazyInit() {
        if (this.entityManagerResolverIsNormalScope == null) {
            this.init(BeanManagerProvider.getInstance().getBeanManager());
        }
    }

    private synchronized void init(BeanManager beanManager) {
        if (this.entityManagerResolverIsNormalScope != null) {
            return;
        }
        this.initialize();
        if (this.entityManagerResolver != null && beanManager != null) {
            Set beans = beanManager.getBeans(this.entityManagerResolver, new Annotation[0]);
            Class scope = beanManager.resolve(beans).getScope();
            this.entityManagerResolverIsNormalScope = beanManager.isNormalScope(scope);
        } else {
            this.entityManagerResolverIsNormalScope = false;
        }
    }

    public boolean isEntityManagerResolverIsNormalScope() {
        this.lazyInit();
        return this.entityManagerResolverIsNormalScope;
    }

    public String getEntityName() {
        return this.repositoryEntity.getEntityName();
    }

    public RepositoryMethod lookupMethod(Method method) {
        this.lazyInit();
        return this.methods.get(method);
    }

    public MethodType lookupMethodType(Method method) {
        return this.lookupMethod(method).getMethodType();
    }

    public Class<?> getEntityClass() {
        return this.repositoryEntity.getEntityClass();
    }

    public Class<? extends Serializable> getPrimaryKey() {
        return this.repositoryEntity.getPrimaryKeyClass();
    }

    public RepositoryEntity getRepositoryEntity() {
        return this.repositoryEntity;
    }

    public Class<?> getRepositoryClass() {
        return this.repoClass;
    }

    public boolean hasEntityManagerResolver() {
        return this.getEntityManagerResolverClass() != null;
    }

    public Class<? extends EntityManagerResolver> getEntityManagerResolverClass() {
        return this.entityManagerResolver;
    }

    public boolean hasEntityManagerFlushMode() {
        return this.entityManagerFlushMode != null;
    }

    public FlushModeType getEntityManagerFlushMode() {
        return this.entityManagerFlushMode;
    }

    private void initialize() {
        Set<Class<?>> allImplemented = this.collectClasses();
        for (Class clazz : allImplemented) {
            Method[] repoClassMethods;
            for (Method repoClassMethod : repoClassMethods = clazz.getDeclaredMethods()) {
                RepositoryMethod repoMethod = new RepositoryMethod(repoClassMethod, this);
                this.methods.put(repoClassMethod, repoMethod);
            }
        }
    }

    private Set<Class<?>> collectClasses() {
        HashSet result = new HashSet();
        this.collectClasses(this.repoClass, result);
        log.log(Level.FINER, "collectClasses(): Found {0} for {1}", new Object[]{result, this.repoClass});
        return result;
    }

    private void collectClasses(Class<?> cls, Set<Class<?>> result) {
        if (cls == null || cls == Object.class) {
            return;
        }
        result.add(cls);
        for (Class<?> child : cls.getInterfaces()) {
            this.collectClasses(child, result);
        }
        this.collectClasses(cls.getSuperclass(), result);
    }

    private Class<? extends EntityManagerResolver> extractEntityManagerResolver(Class<?> clazz) {
        EntityManagerConfig config = this.extractEntityManagerConfig(clazz);
        if (config != null && !EntityManagerResolver.class.equals((Object)config.entityManagerResolver())) {
            return config.entityManagerResolver();
        }
        return null;
    }

    private FlushModeType extractEntityManagerFlushMode(Class<?> clazz) {
        EntityManagerConfig config = this.extractEntityManagerConfig(clazz);
        if (config != null) {
            return config.flushMode();
        }
        return null;
    }

    private EntityManagerConfig extractEntityManagerConfig(Class<?> clazz) {
        if (clazz.isAnnotationPresent(EntityManagerConfig.class)) {
            return clazz.getAnnotation(EntityManagerConfig.class);
        }
        return null;
    }

    public String getCustomMethodPrefix() {
        return this.repoClass.getAnnotation(Repository.class).methodPrefix();
    }
}

