/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.handler;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.deltaspike.core.api.lifecycle.Initialized;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.AnnotationUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.core.util.ProxyUtils;
import org.apache.deltaspike.core.util.interceptor.AbstractInvocationContext;
import org.apache.deltaspike.core.util.metadata.AnnotationInstanceProvider;
import org.apache.deltaspike.data.api.QueryInvocationException;
import org.apache.deltaspike.data.api.Repository;
import org.apache.deltaspike.data.impl.builder.QueryBuilder;
import org.apache.deltaspike.data.impl.builder.QueryBuilderFactory;
import org.apache.deltaspike.data.impl.handler.CdiQueryContextHolder;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.handler.EntityManagerRef;
import org.apache.deltaspike.data.impl.handler.EntityManagerRefLookup;
import org.apache.deltaspike.data.impl.handler.QueryRunner;
import org.apache.deltaspike.data.impl.meta.RepositoryComponent;
import org.apache.deltaspike.data.impl.meta.RepositoryComponents;
import org.apache.deltaspike.data.impl.meta.RepositoryMethod;
import org.apache.deltaspike.jpa.api.transaction.Transactional;
import org.apache.deltaspike.jpa.spi.entitymanager.ActiveEntityManagerHolder;
import org.apache.deltaspike.jpa.spi.transaction.TransactionStrategy;

@Repository
@ApplicationScoped
public class QueryHandler
implements Serializable,
InvocationHandler {
    private static final Logger log = Logger.getLogger(QueryHandler.class.getName());
    @Inject
    private QueryBuilderFactory queryBuilderFactory;
    @Inject
    @Initialized
    private RepositoryComponents components;
    @Inject
    private CdiQueryContextHolder context;
    @Inject
    private EntityManagerRefLookup entityManagerRefLookup;
    @Inject
    private QueryRunner runner;
    @Inject
    private BeanManager beanManager;
    @Inject
    private TransactionStrategy transactionStrategy;
    @Inject
    private ActiveEntityManagerHolder activeEntityManagerHolder;

    @Override
    public Object invoke(final Object proxy, Method method, final Object[] args) throws Throwable {
        Transactional transactionalAnnotation = (Transactional)AnnotationUtils.extractAnnotationFromMethodOrClass((BeanManager)this.beanManager, (Method)method, proxy.getClass(), Transactional.class);
        if (transactionalAnnotation != null) {
            if (transactionalAnnotation.qualifier().length > 1) {
                throw new IllegalStateException(proxy.getClass().getName() + " uses @" + Transactional.class.getName() + " with multiple qualifiers. That isn't supported with @" + Repository.class.getName());
            }
            Class qualifier = transactionalAnnotation.qualifier()[0];
            if (!Any.class.equals((Object)qualifier)) {
                EntityManager entityManager = (EntityManager)BeanProvider.getContextualReference(EntityManager.class, (boolean)false, (Annotation[])new Annotation[]{AnnotationInstanceProvider.of((Class)qualifier)});
                this.activeEntityManagerHolder.set(entityManager);
            }
            return this.transactionStrategy.execute((InvocationContext)new AbstractInvocationContext<Object>(proxy, method, args, null){

                public Object proceed() throws Exception {
                    try {
                        return QueryHandler.this.process(proxy, this.method, args);
                    }
                    catch (Throwable t) {
                        throw ExceptionUtils.throwAsRuntimeException((Throwable)t);
                    }
                }
            });
        }
        return this.process(proxy, method, args);
    }

    public Object process(Object proxy, Method method, Object[] args) throws Throwable {
        CdiQueryInvocationContext queryContext = null;
        EntityManagerRef entityManagerRef = null;
        try {
            Object result;
            List candidates = ProxyUtils.getProxyAndBaseTypes(proxy.getClass());
            RepositoryComponent repo = this.components.lookupComponent(candidates);
            RepositoryMethod repoMethod = this.components.lookupMethod(repo, method);
            entityManagerRef = this.entityManagerRefLookup.lookupReference(repo);
            queryContext = this.createContext(proxy, method, args, entityManagerRef.getEntityManager(), repoMethod);
            QueryBuilder builder = this.queryBuilderFactory.build(repoMethod, queryContext);
            Object object = result = this.runner.executeQuery(builder, queryContext);
            return object;
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Query execution error", e);
            if (queryContext != null) {
                throw new QueryInvocationException((Throwable)e, queryContext);
            }
            throw new QueryInvocationException((Throwable)e, proxy.getClass(), method);
        }
        finally {
            if (entityManagerRef != null) {
                entityManagerRef.release();
            }
            this.context.dispose();
        }
    }

    private CdiQueryInvocationContext createContext(Object proxy, Method method, Object[] args, EntityManager entityManager, RepositoryMethod repoMethod) {
        CdiQueryInvocationContext queryContext = new CdiQueryInvocationContext(proxy, method, args, repoMethod, entityManager);
        this.context.set(queryContext);
        queryContext.initMapper();
        return queryContext;
    }
}

