/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.handler;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.api.provider.DependentProvider;
import org.apache.deltaspike.data.api.EntityManagerResolver;
import org.apache.deltaspike.data.impl.handler.EntityManagerRef;
import org.apache.deltaspike.data.impl.meta.RepositoryComponent;
import org.apache.deltaspike.jpa.spi.entitymanager.ActiveEntityManagerHolder;

@ApplicationScoped
public class EntityManagerRefLookup {
    @Inject
    private ActiveEntityManagerHolder activeEntityManagerHolder;
    private volatile Boolean globalEntityManagerInitialized;
    private boolean globalEntityManagerIsNormalScope;
    private EntityManager globalEntityManager;

    private void lazyInitGlobalEntityManager() {
        if (this.globalEntityManagerInitialized == null) {
            this.initGlobalEntityManager();
        }
    }

    private synchronized void initGlobalEntityManager() {
        if (this.globalEntityManagerInitialized == null) {
            Set beans;
            this.globalEntityManagerInitialized = true;
            BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
            Bean bean = beanManager.resolve(beans = beanManager.getBeans(EntityManager.class, new Annotation[0]));
            if (bean == null) {
                throw new IllegalStateException("Could not find EntityManager with default qualifier.");
            }
            this.globalEntityManagerIsNormalScope = beanManager.isNormalScope(bean.getScope());
            if (this.globalEntityManagerIsNormalScope) {
                this.globalEntityManager = (EntityManager)beanManager.getReference(bean, EntityManager.class, beanManager.createCreationalContext((Contextual)bean));
            }
        }
    }

    public EntityManagerRef lookupReference(RepositoryComponent repository) {
        EntityManagerRef ref = new EntityManagerRef();
        if (repository.hasEntityManagerResolver()) {
            ref.setEntityManagerResolverClass(repository.getEntityManagerResolverClass());
            if (repository.isEntityManagerResolverIsNormalScope()) {
                ref.setEntityManagerResolver((EntityManagerResolver)BeanProvider.getContextualReference(ref.getEntityManagerResolverClass(), (Annotation[])new Annotation[0]));
            } else {
                ref.setEntityManagerResolverDependentProvider((DependentProvider<? extends EntityManagerResolver>)BeanProvider.getDependent(ref.getEntityManagerResolverClass(), (Annotation[])new Annotation[0]));
                ref.setEntityManagerResolver((EntityManagerResolver)ref.getEntityManagerResolverDependentProvider().get());
            }
            ref.setEntityManager(ref.getEntityManagerResolver().resolveEntityManager());
        } else {
            if (this.activeEntityManagerHolder.isSet()) {
                ref.setEntityManager(this.activeEntityManagerHolder.get());
                return ref;
            }
            this.lazyInitGlobalEntityManager();
            if (this.globalEntityManagerIsNormalScope) {
                ref.setEntityManager(this.globalEntityManager);
            } else {
                ref.setEntityManagerDependentProvider((DependentProvider<? extends EntityManager>)BeanProvider.getDependent(EntityManager.class, (Annotation[])new Annotation[0]));
                ref.setEntityManager((EntityManager)ref.getEntityManagerDependentProvider().get());
            }
        }
        if (repository.hasEntityManagerFlushMode()) {
            ref.getEntityManager().setFlushMode(repository.getEntityManagerFlushMode());
        }
        return ref;
    }
}

