/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder.result;

import java.lang.reflect.Method;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.deltaspike.core.util.OptionalUtil;
import org.apache.deltaspike.core.util.StreamUtil;
import org.apache.deltaspike.data.api.Modifying;
import org.apache.deltaspike.data.api.QueryResult;
import org.apache.deltaspike.data.api.SingleResultType;
import org.apache.deltaspike.data.impl.builder.result.QueryProcessor;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.meta.MethodPrefix;

public final class QueryProcessorFactory {
    private final Method method;
    private final MethodPrefix methodPrefix;

    private QueryProcessorFactory(Method method) {
        this.method = method;
        this.methodPrefix = new MethodPrefix("", method.getName());
    }

    private QueryProcessorFactory(Method method, MethodPrefix methodPrefix) {
        this.method = method;
        this.methodPrefix = methodPrefix;
    }

    public static QueryProcessorFactory newInstance(Method method) {
        return new QueryProcessorFactory(method);
    }

    public static QueryProcessorFactory newInstance(Method method, MethodPrefix methodPrefix) {
        return new QueryProcessorFactory(method, methodPrefix);
    }

    public QueryProcessor build() {
        if (this.returns(QueryResult.class)) {
            return new NoOpQueryProcessor();
        }
        if (this.returns(List.class)) {
            return new ListQueryProcessor();
        }
        if (this.streams()) {
            return new StreamQueryProcessor();
        }
        if (this.isModifying()) {
            return new ExecuteUpdateQueryProcessor(this.returns(Void.TYPE));
        }
        return new SingleResultQueryProcessor();
    }

    private boolean isModifying() {
        boolean matchesType = Void.TYPE.equals(this.method.getReturnType()) || Integer.TYPE.equals(this.method.getReturnType()) || Integer.class.equals(this.method.getReturnType());
        return this.method.isAnnotationPresent(Modifying.class) && matchesType || this.methodPrefix.isDelete();
    }

    private boolean returns(Class<?> clazz) {
        return this.method.getReturnType().isAssignableFrom(clazz);
    }

    private boolean streams() {
        return StreamUtil.isStreamReturned((Method)this.method);
    }

    private static final class ExecuteUpdateQueryProcessor
    implements QueryProcessor {
        private final boolean returnsVoid;

        private ExecuteUpdateQueryProcessor(boolean returnsVoid) {
            this.returnsVoid = returnsVoid;
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            int result = query.executeUpdate();
            if (!this.returnsVoid) {
                return result;
            }
            return null;
        }
    }

    private static final class SingleResultQueryProcessor
    implements QueryProcessor {
        private SingleResultQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            SingleResultType style = context.getSingleResultStyle();
            Object result = null;
            switch (style) {
                case JPA: {
                    return query.getSingleResult();
                }
                case OPTIONAL: {
                    try {
                        result = query.getSingleResult();
                    }
                    catch (NoResultException noResultException) {}
                    break;
                }
                default: {
                    List queryResult = query.getResultList();
                    Object object = result = !queryResult.isEmpty() ? (Object)queryResult.get(0) : null;
                }
            }
            if (context.isOptional()) {
                return OptionalUtil.wrap((Object)result);
            }
            return result;
        }
    }

    private static final class StreamQueryProcessor
    implements QueryProcessor {
        private StreamQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            return StreamUtil.wrap((Object)query.getResultList());
        }
    }

    private static final class NoOpQueryProcessor
    implements QueryProcessor {
        private NoOpQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            return query;
        }
    }

    private static final class ListQueryProcessor
    implements QueryProcessor {
        private ListQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            return query.getResultList();
        }
    }
}

