/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder.part;

import org.apache.deltaspike.data.impl.builder.MethodExpressionException;
import org.apache.deltaspike.data.impl.builder.part.QueryPart;
import org.apache.deltaspike.data.impl.meta.RepositoryComponent;
import org.apache.deltaspike.data.impl.property.Property;
import org.apache.deltaspike.data.impl.property.query.NamedPropertyCriteria;
import org.apache.deltaspike.data.impl.property.query.PropertyQueries;
import org.apache.deltaspike.data.impl.property.query.PropertyQuery;

abstract class BasePropertyQueryPart
extends QueryPart {
    static final String SEPARATOR = "_";

    BasePropertyQueryPart() {
    }

    void validate(String name, String method, RepositoryComponent repo) {
        Class<Object> current = repo.getEntityClass();
        if (name == null) {
            throw new MethodExpressionException(null, repo.getRepositoryClass(), method);
        }
        for (String property : name.split(SEPARATOR)) {
            PropertyQuery query = PropertyQueries.createQuery(current).addCriteria(new NamedPropertyCriteria(property));
            Property result = query.getFirstResult();
            if (result == null) {
                throw new MethodExpressionException(property, repo.getRepositoryClass(), method);
            }
            current = result.getJavaClass();
        }
    }

    String rewriteSeparator(String name) {
        if (name.contains(SEPARATOR)) {
            return name.replaceAll(SEPARATOR, ".");
        }
        return name;
    }
}

