/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta.unit;

import java.io.Serializable;
import org.apache.deltaspike.data.impl.property.query.NamedPropertyCriteria;
import org.apache.deltaspike.data.impl.property.query.PropertyQueries;
import org.apache.deltaspike.data.impl.property.query.PropertyQuery;

abstract class PersistentClassDescriptor {
    protected final String name;
    protected final Class<?> entityClass;
    protected final Class<? extends Serializable> idClass;
    protected final String id;
    private PersistentClassDescriptor parent;

    PersistentClassDescriptor(String name, String packageName, String className, String idClass, String id) {
        Class<?> clazz = this.entityClass(className, packageName);
        this.name = name;
        this.entityClass = clazz;
        this.idClass = this.idClass(clazz, idClass, packageName, id);
        this.id = id;
    }

    public Class<? extends Serializable> getIdClass() {
        return this.idClass;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    String className(Class<?> clazz) {
        return clazz == null ? null : clazz.getSimpleName();
    }

    private Class<?> entityClass(String entityClass, String packageName) {
        try {
            String clazzName = this.buildClassName(entityClass, packageName);
            return Class.forName(clazzName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't create class " + this.buildClassName(entityClass, packageName), e);
        }
    }

    private Class<? extends Serializable> idClass(Class<?> entity, String idClass, String packageName, String id) {
        try {
            return idClass != null ? Class.forName(this.buildClassName(idClass, packageName)) : this.lookupIdClass(entity, id);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to get ID class", e);
        }
    }

    private Class<?> lookupIdClass(Class<?> entity, String id) {
        if (entity == null || id == null) {
            return null;
        }
        PropertyQuery query = PropertyQueries.createQuery(entity).addCriteria(new NamedPropertyCriteria(id));
        return query.getFirstResult().getJavaClass();
    }

    private String buildClassName(String clazzName, String packageName) {
        if (clazzName == null && packageName == null) {
            return null;
        }
        return packageName != null && !this.isClassNameQualified(clazzName) ? packageName + "." + clazzName : clazzName;
    }

    private boolean isClassNameQualified(String name) {
        return name.contains(".");
    }

    public PersistentClassDescriptor getParent() {
        return this.parent;
    }

    public void setParent(PersistentClassDescriptor parent) {
        this.parent = parent;
    }
}

