/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta.unit;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.deltaspike.data.impl.meta.unit.Descriptor;
import org.apache.deltaspike.data.impl.meta.unit.DescriptorReader;
import org.apache.deltaspike.data.impl.meta.unit.EntityDescriptor;
import org.apache.deltaspike.data.impl.meta.unit.MappedSuperclassDescriptor;
import org.apache.deltaspike.data.impl.meta.unit.PersistentClassDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EntityDescriptorReader
extends DescriptorReader {
    public MappingFile readAll(String baseUrl, String resource) throws IOException {
        return this.readFromDocument(this.read(baseUrl, resource).getDocument());
    }

    public MappingFile readDefaultOrm(String baseUrl) throws IOException {
        try {
            Descriptor desc = this.read(baseUrl, "META-INF/orm.xml");
            return this.readFromDocument(desc.getDocument());
        }
        catch (Exception e) {
            return new MappingFile(Collections.<EntityDescriptor>emptyList(), Collections.<MappedSuperclassDescriptor>emptyList());
        }
    }

    public MappingFile readFromDocument(Document doc) {
        List<EntityDescriptor> entities = new EntityBuilder<EntityDescriptor>(){

            @Override
            EntityDescriptor instance(String name, String packageName, String className, String idClass, String id) {
                return new EntityDescriptor(name, packageName, className, idClass, id);
            }

            @Override
            String tagName() {
                return "entity";
            }
        }.build(doc);
        List<MappedSuperclassDescriptor> superClasses = new EntityBuilder<MappedSuperclassDescriptor>(){

            @Override
            MappedSuperclassDescriptor instance(String name, String packageName, String className, String idClass, String id) {
                return new MappedSuperclassDescriptor(name, packageName, className, idClass, id);
            }

            @Override
            String tagName() {
                return "mapped-superclass";
            }
        }.build(doc);
        return new MappingFile(entities, superClasses);
    }

    private String extractNodeAttribute(Element element, String childName, String attribute) {
        NodeList list = element.getElementsByTagName(childName);
        if (list.getLength() == 0) {
            return null;
        }
        return this.extractAttribute(list.item(0), attribute);
    }

    private String extractAttribute(Node item, String name) {
        Node node = item.getAttributes().getNamedItem(name);
        if (node != null) {
            return node.getTextContent();
        }
        return null;
    }

    private String extractNodeContent(Element element, String name) {
        NodeList list = element.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return null;
        }
        return list.item(0).getTextContent();
    }

    private abstract class EntityBuilder<T extends PersistentClassDescriptor> {
        private EntityBuilder() {
        }

        public List<T> build(Document doc) {
            LinkedList<T> result = new LinkedList<T>();
            String packageName = EntityDescriptorReader.this.extractNodeContent(doc.getDocumentElement(), "package");
            NodeList mappings = doc.getElementsByTagName(this.tagName());
            for (int i = 0; i < mappings.getLength(); ++i) {
                String name = EntityDescriptorReader.this.extractAttribute(mappings.item(i), "name");
                String className = EntityDescriptorReader.this.extractAttribute(mappings.item(i), "class");
                String idClass = EntityDescriptorReader.this.extractNodeAttribute((Element)mappings.item(i), "id-class", "class");
                String id = EntityDescriptorReader.this.extractNodeAttribute((Element)mappings.item(i), "id", "name");
                String embeddedId = EntityDescriptorReader.this.extractNodeAttribute((Element)mappings.item(i), "embedded-id", "name");
                result.add(this.instance(name, packageName, className, idClass, id != null ? id : embeddedId));
            }
            return result;
        }

        abstract T instance(String var1, String var2, String var3, String var4, String var5);

        abstract String tagName();
    }

    public static class MappingFile {
        private final List<EntityDescriptor> entities;
        private final List<MappedSuperclassDescriptor> superClasses;

        public MappingFile(List<EntityDescriptor> entities, List<MappedSuperclassDescriptor> superClasses) {
            this.entities = entities;
            this.superClasses = superClasses;
        }

        public List<EntityDescriptor> getEntities() {
            return this.entities;
        }

        public List<MappedSuperclassDescriptor> getSuperClasses() {
            return this.superClasses;
        }
    }
}

