/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.From;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.deltaspike.data.api.criteria.Criteria;
import org.apache.deltaspike.data.api.criteria.QuerySelection;
import org.apache.deltaspike.data.impl.builder.OrderDirection;
import org.apache.deltaspike.data.impl.criteria.predicate.Between;
import org.apache.deltaspike.data.impl.criteria.predicate.Eq;
import org.apache.deltaspike.data.impl.criteria.predicate.FetchBuilder;
import org.apache.deltaspike.data.impl.criteria.predicate.GreaterThan;
import org.apache.deltaspike.data.impl.criteria.predicate.GreaterThanOrEqual;
import org.apache.deltaspike.data.impl.criteria.predicate.In;
import org.apache.deltaspike.data.impl.criteria.predicate.IsEmpty;
import org.apache.deltaspike.data.impl.criteria.predicate.IsNotEmpty;
import org.apache.deltaspike.data.impl.criteria.predicate.IsNotNull;
import org.apache.deltaspike.data.impl.criteria.predicate.IsNull;
import org.apache.deltaspike.data.impl.criteria.predicate.JoinBuilder;
import org.apache.deltaspike.data.impl.criteria.predicate.LessThan;
import org.apache.deltaspike.data.impl.criteria.predicate.LessThanOrEqual;
import org.apache.deltaspike.data.impl.criteria.predicate.Like;
import org.apache.deltaspike.data.impl.criteria.predicate.NotEq;
import org.apache.deltaspike.data.impl.criteria.predicate.NotLike;
import org.apache.deltaspike.data.impl.criteria.predicate.OrBuilder;
import org.apache.deltaspike.data.impl.criteria.predicate.PredicateBuilder;
import org.apache.deltaspike.data.impl.criteria.processor.OrderBy;
import org.apache.deltaspike.data.impl.criteria.processor.QueryProcessor;

public class QueryCriteria<C, R>
implements Criteria<C, R> {
    private static final Logger log = Logger.getLogger(QueryCriteria.class.getName());
    private EntityManager entityManager;
    private Class<C> entityClass;
    private Class<R> resultClass;
    private JoinType joinType;
    private final boolean ignoreNull = true;
    private boolean distinct = false;
    private final List<PredicateBuilder<C>> builders = new LinkedList<PredicateBuilder<C>>();
    private final List<QueryProcessor<C>> processors = new LinkedList<QueryProcessor<C>>();
    private final List<QuerySelection<? super C, ?>> selections = new LinkedList();

    public QueryCriteria(Class<C> entityClass, Class<R> resultClass, EntityManager entityManager) {
        this(entityClass, resultClass, entityManager, null);
    }

    public QueryCriteria(Class<C> entityClass, Class<R> resultClass, EntityManager entityManager, JoinType joinType) {
        this.entityManager = entityManager;
        this.entityClass = entityClass;
        this.resultClass = resultClass;
        this.joinType = joinType;
    }

    public List<R> getResultList() {
        return this.createQuery().getResultList();
    }

    public R getSingleResult() {
        return (R)this.createQuery().getSingleResult();
    }

    public R getOptionalResult() {
        try {
            return this.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public R getAnyResult() {
        List<R> queryResult = this.getResultList();
        return queryResult.size() > 0 ? (R)queryResult.get(0) : null;
    }

    public TypedQuery<R> createQuery() {
        try {
            CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
            CriteriaQuery<?> query = this.createCriteriaQuery(builder);
            Root root = query.from(this.entityClass);
            if (!this.selections.isEmpty()) {
                query.multiselect(this.prepareSelections(query, builder, (From<C, C>)root));
            }
            List<Predicate> predicates = this.predicates(builder, (Path<C>)root);
            query.distinct(this.distinct);
            if (!predicates.isEmpty()) {
                query.where(predicates.toArray(new Predicate[predicates.size()]));
            }
            this.applyProcessors(query, builder, (From<C, C>)root);
            return this.entityManager.createQuery(query);
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "Exception while creating JPA query", e);
            throw e;
        }
    }

    public Criteria<C, R> or(Criteria<C, R> ... criteria) {
        return this.internalOr(criteria);
    }

    public Criteria<C, R> or(Collection<Criteria<C, R>> criteria) {
        return this.internalOr(criteria.toArray(new Criteria[criteria.size()]));
    }

    public <P, E> Criteria<C, R> join(SingularAttribute<? super C, P> att, Criteria<P, P> criteria) {
        this.add(new JoinBuilder(criteria, this.joinType, att));
        return this;
    }

    public <P, E> Criteria<C, R> join(ListAttribute<? super C, P> att, Criteria<P, P> criteria) {
        this.add(new JoinBuilder(criteria, this.joinType, att));
        return this;
    }

    public <P, E> Criteria<C, R> join(CollectionAttribute<? super C, P> att, Criteria<P, P> criteria) {
        this.add(new JoinBuilder(criteria, this.joinType, att));
        return this;
    }

    public <P, E> Criteria<C, R> join(SetAttribute<? super C, P> att, Criteria<P, P> criteria) {
        this.add(new JoinBuilder(criteria, this.joinType, att));
        return this;
    }

    public <P, E> Criteria<C, R> join(MapAttribute<? super C, E, P> att, Criteria<P, P> criteria) {
        this.add(new JoinBuilder<C, P, E>(criteria, this.joinType, att));
        return this;
    }

    public <P, E> Criteria<C, R> fetch(SingularAttribute<? super C, P> att) {
        this.add(new FetchBuilder(att, null));
        return this;
    }

    public <P, E> Criteria<C, R> fetch(SingularAttribute<? super C, P> att, JoinType joinType) {
        this.add(new FetchBuilder(att, joinType));
        return this;
    }

    public <P, E> Criteria<C, R> fetch(PluralAttribute<? super C, P, E> att) {
        this.add(new FetchBuilder<C, P, E>(att, null));
        return this;
    }

    public <P, E> Criteria<C, R> fetch(PluralAttribute<? super C, P, E> att, JoinType joinType) {
        this.add(new FetchBuilder<C, P, E>(att, joinType));
        return this;
    }

    public <P> Criteria<C, R> orderAsc(SingularAttribute<? super C, P> att) {
        this.add(new OrderBy<C, P>(att, OrderDirection.ASC));
        return this;
    }

    public <P> Criteria<C, R> orderDesc(SingularAttribute<? super C, P> att) {
        this.add(new OrderBy<C, P>(att, OrderDirection.DESC));
        return this;
    }

    public Criteria<C, R> distinct() {
        this.distinct = true;
        return this;
    }

    public <N> Criteria<C, N> select(Class<N> resultClass, QuerySelection<? super C, ?> ... selection) {
        QueryCriteria<C, N> result = new QueryCriteria<C, N>(this.entityClass, resultClass, this.entityManager, this.joinType);
        result.builders.addAll(this.builders);
        result.distinct = this.distinct;
        result.processors.addAll(this.processors);
        result.selections.addAll(Arrays.asList(selection));
        return result;
    }

    public Criteria<C, Object[]> select(QuerySelection<? super C, ?> ... selection) {
        return this.select(Object[].class, selection);
    }

    public List<Predicate> predicates(CriteriaBuilder builder, Path<C> path) {
        LinkedList<Predicate> predicates = new LinkedList<Predicate>();
        for (PredicateBuilder<C> pbuilder : this.builders) {
            List<Predicate> p = pbuilder.build(builder, path);
            predicates.addAll(p);
        }
        return predicates;
    }

    void applyProcessors(CriteriaQuery<?> query, CriteriaBuilder builder, From<C, C> from) {
        for (QueryProcessor<C> proc : this.processors) {
            proc.process(query, builder, (Path<C>)from);
        }
    }

    Criteria<C, R> internalOr(Criteria<C, R> ... others) {
        LinkedList<Criteria<C, R>> list = new LinkedList<Criteria<C, R>>();
        list.addAll(Arrays.asList(others));
        this.add(new OrBuilder(list.toArray(new Criteria[list.size()])));
        return this;
    }

    private void add(PredicateBuilder<C> pred) {
        this.builders.add(pred);
    }

    private <P> void add(PredicateBuilder<C> pred, P value) {
        if (value != null) {
            this.builders.add(pred);
        }
    }

    private void add(QueryProcessor<C> proc) {
        this.processors.add(proc);
    }

    private Selection<?>[] prepareSelections(CriteriaQuery<?> query, CriteriaBuilder builder, From<C, C> root) {
        ArrayList<Selection> result = new ArrayList<Selection>(this.selections.size());
        for (QuerySelection<? super C, ?> querySelection : this.selections) {
            result.add(querySelection.toSelection(query, builder, root));
        }
        return result.toArray(new Selection[0]);
    }

    private CriteriaQuery<?> createCriteriaQuery(CriteriaBuilder builder) {
        if (this.resultClass.getName().startsWith("java.lang")) {
            return builder.createQuery();
        }
        return builder.createQuery(this.resultClass);
    }

    public <P> Criteria<C, R> eq(SingularAttribute<? super C, P> att, P value) {
        this.add(new Eq<C, P>(att, value), value);
        return this;
    }

    public <P> Criteria<C, R> notEq(SingularAttribute<? super C, P> att, P value) {
        this.add(new NotEq<C, P>(att, value), value);
        return this;
    }

    public <P> Criteria<C, R> like(SingularAttribute<? super C, String> att, String value) {
        this.add(new Like<C>(att, value), value);
        return this;
    }

    public <P> Criteria<C, R> notLike(SingularAttribute<? super C, String> att, String value) {
        this.add(new NotLike<C>(att, value), value);
        return this;
    }

    public <P extends Comparable<? super P>> Criteria<C, R> lt(SingularAttribute<? super C, P> att, P value) {
        this.add(new LessThan<C, P>(att, value), value);
        return this;
    }

    public <P extends Comparable<? super P>> Criteria<C, R> ltOrEq(SingularAttribute<? super C, P> att, P value) {
        this.add(new LessThanOrEqual<C, P>(att, value), value);
        return this;
    }

    public <P extends Comparable<? super P>> Criteria<C, R> gt(SingularAttribute<? super C, P> att, P value) {
        this.add(new GreaterThan<C, P>(att, value), value);
        return this;
    }

    public <P extends Comparable<? super P>> Criteria<C, R> gtOrEq(SingularAttribute<? super C, P> att, P value) {
        this.add(new GreaterThanOrEqual<C, P>(att, value), value);
        return this;
    }

    public <P extends Comparable<? super P>> Criteria<C, R> between(SingularAttribute<? super C, P> att, P lower, P upper) {
        this.add(new Between<C, P>(att, lower, upper));
        return this;
    }

    public <P> Criteria<C, R> isNull(SingularAttribute<? super C, P> att) {
        this.add(new IsNull<C, P>(att));
        return this;
    }

    public <P> Criteria<C, R> notNull(SingularAttribute<? super C, P> att) {
        this.add(new IsNotNull<C, P>(att));
        return this;
    }

    public <P extends Collection<?>> Criteria<C, R> empty(SingularAttribute<? super C, P> att) {
        this.add(new IsEmpty<C, P>(att));
        return this;
    }

    public <P extends Collection<?>> Criteria<C, R> notEmpty(SingularAttribute<? super C, P> att) {
        this.add(new IsNotEmpty<C, P>(att));
        return this;
    }

    public <P> Criteria<C, R> in(SingularAttribute<? super C, P> att, P ... values) {
        this.add(new In<C, P>(att, values), values);
        return this;
    }
}

